/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowEmailIssueFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private Logger log = LoggerFactory.getLogger(WorkflowEmailIssueFunction.class);
    private final ProjectRoleManager projectRoleManager;
    private final FieldManager fieldManager;

    public WorkflowEmailIssueFunction(ThirdPartyPluginLicenseStorageManager licenseManager, ProjectRoleManager projectRoleManager, FieldManager fieldManager) {
        super(licenseManager);
        this.projectRoleManager = projectRoleManager;
        this.fieldManager = fieldManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        velocityParams.put("subject", Utils.decodeTemplate((String)functionDescriptor.getArgs().get("subject")));
        velocityParams.put("htmlBody", Utils.decodeTemplate((String)functionDescriptor.getArgs().get("htmlBody")));
        velocityParams.put("textBody", Utils.decodeTemplate((String)functionDescriptor.getArgs().get("textBody")));
        velocityParams.put("toReporter", functionDescriptor.getArgs().get("toReporter"));
        velocityParams.put("toAssignee", functionDescriptor.getArgs().get("toAssignee"));
        velocityParams.put("toWatchers", functionDescriptor.getArgs().get("toWatchers"));
        velocityParams.put("toVoters", functionDescriptor.getArgs().get("toVoters"));
        velocityParams.put("toUsers", functionDescriptor.getArgs().get("toUsers"));
        Object toUserFields = functionDescriptor.getArgs().get("toUserFields");
        velocityParams.put("toUserFields", toUserFields);
        velocityParams.put("toUsersScript", functionDescriptor.getArgs().get("toUsersScript"));
        velocityParams.put("toGroups", functionDescriptor.getArgs().get("toGroups"));
        String toRoleMembers = (String)functionDescriptor.getArgs().get("toRoleMembers");
        velocityParams.put("toRoleMembers", toRoleMembers);
        ArrayList<String> roleNames = new ArrayList<String>();
        if (!StringUtils.isEmpty(toRoleMembers)) {
            for (String roleId : toRoleMembers.split(",")) {
                try {
                    Long roleIdNum = Long.parseLong(roleId);
                    ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleIdNum);
                    if (projectRole != null) {
                        roleNames.add(projectRole.getName());
                        continue;
                    }
                    this.log.error("No project role with ID: " + roleId);
                }
                catch (NumberFormatException e) {
                    this.log.error("Invalid project role ID: " + roleId);
                }
            }
            velocityParams.put("toRoleMemberNames", StringUtils.join(roleNames, ","));
        }
        if (!StringUtils.isEmpty((CharSequence)toUserFields)) {
            StringBuilder sb = new StringBuilder();
            boolean bFirst = true;
            for (String fieldKey : ((String)toUserFields).split(",")) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append(", ");
                }
                Field f = this.fieldManager.getField(fieldKey);
                if (f == null) {
                    sb.append("<i>Invalid field (" + fieldKey + ")</i>");
                    continue;
                }
                sb.append(f.getName());
            }
            velocityParams.put("toUserFieldNames", sb.toString());
        }
        velocityParams.put("runAsUser", functionDescriptor.getArgs().get("runAsUser"));
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map velocityParams) {
        String val;
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String groovyExpression = Utils.encodeTemplate(this.extractSingleParam(velocityParams, "subject"));
            params.put("subject", groovyExpression);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Email issue post-function: Subject is required");
        }
        try {
            val = Utils.encodeTemplate(this.extractSingleParam(velocityParams, "htmlBody"));
            params.put("htmlBody", val);
        }
        catch (IllegalArgumentException e) {
            params.put("htmlBody", "");
        }
        try {
            val = Utils.encodeTemplate(this.extractSingleParam(velocityParams, "textBody"));
            params.put("textBody", val);
        }
        catch (IllegalArgumentException e) {
            params.put("textBody", "");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toReporter");
            params.put("toReporter", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toReporter", "no");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toAssignee");
            params.put("toAssignee", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toAssignee", "no");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toWatchers");
            params.put("toWatchers", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toWatchers", "no");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toVoters");
            params.put("toVoters", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toVoters", "no");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toUsers");
            params.put("toUsers", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toUsers", "");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toUserFields");
            params.put("toUserFields", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toUserFields", "");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toUsersScript");
            params.put("toUsersScript", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toUsersScript", "");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toGroups");
            params.put("toGroups", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toGroups", "");
        }
        try {
            val = this.extractSingleParam(velocityParams, "toRoleMembers");
            params.put("toRoleMembers", val);
        }
        catch (IllegalArgumentException e) {
            params.put("toRoleMembers", "");
        }
        try {
            params.put("runAsUser", this.extractSingleParam(velocityParams, "runAsUser"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        params.putAll(super.getDescriptorParams(velocityParams));
        return params;
    }
}

