/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.innovalog.jmwe.plugins.functions.LinkUtil;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCreateIssueFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    public static final String ISSUETYPE = "issuetype";
    private Logger log = LoggerFactory.getLogger(WorkflowCreateIssueFunction.class);
    private final WorkflowUtils workflowUtils;
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final ProjectRoleManager projectRoleManager;
    private static final String LINK_TYPES_LIST = "linkTypeList";
    private static final String FIELD_LIST = "fieldList";
    private static final String FIELD_MAP = "fieldMap";
    public static final String PROJECT_KEY = "projectKey";
    public static final String FIELDS_TO_SET = "fieldsToSet";
    public static final String CALCULATED_PROJECT_KEY = "calculatedProjectKey";
    public static final String PARENT_ISSUE_TYPE = "parentIssueType";
    public static final String CALCULATED_PARENT_ISSUE = "calculatedParentIssue";
    public static final String SELECTED_LINK_TYPE = "selectedLinkType";
    public static final String COMMENT_ISSUE = "commentIssue";
    public static final String COMMENT_TYPE = "commentType";
    public static final String RAW_VALUE = "rawValue";
    public static final String COMMENT = "comment";
    public static final String SEND_NOTIF = "sendNotification";
    public static final String RESTRICT_TO_GROUP = "restrictToGroup";
    public static final String RESTRICT_TO_ROLE = "restrictToProjectRole";
    public static final String RESTRICT_TO_ROLE_NAME = "restrictToProjectRoleName";
    public static final String RESTRICT_TO_INTERNAL = "restrictToInternal";
    public static final String RUN_AS_USER = "runAsUser";
    public static final String SAME_AS_CURRENT_ISSUE = "$sameAsCurrentIssue$";
    public static final String CALCULATED = "$calculated$";
    static final String INWARD = "inward";
    private static final String LINK_TYPE_NAME = "linkTypeName";

    public WorkflowCreateIssueFunction(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, ProjectManager projectManager, IssueTypeManager issueTypeManager, IssueLinkTypeManager issueLinkTypeManager, ProjectRoleManager projectRoleManager) {
        super(licenseManager);
        this.workflowUtils = workflowUtils;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.projectRoleManager = projectRoleManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        ArrayList<ProjectDef> projects = new ArrayList<ProjectDef>();
        HashMap<String, IssueTypeDef> issueTypes = new HashMap<String, IssueTypeDef>();
        for (Project project : this.projectManager.getProjectObjects()) {
            ProjectDef projectDef = new ProjectDef(project.getKey(), project.getName());
            projects.add(projectDef);
            for (Object issueType : project.getIssueTypes()) {
                IssueTypeDef issueTypeDef = new IssueTypeDef(issueType.getId(), issueType.getName(), issueType.isSubTask());
                projectDef.addIssueType(issueTypeDef);
                issueTypes.put(issueTypeDef.id, issueTypeDef);
            }
        }
        velocityParams.put("projects", projects);
        velocityParams.put("projectsAsJSONHtml", new com.atlassian.adapter.jackson.ObjectMapper().writeValueAsString(projects));
        ArrayList issueTypeDefs = new ArrayList(issueTypes.values());
        velocityParams.put("issueTypes", issueTypeDefs);
        velocityParams.put("issueTypesAsJSONHtml", new com.atlassian.adapter.jackson.ObjectMapper().writeValueAsString(issueTypeDefs));
        Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypes(true);
        velocityParams.put(LINK_TYPES_LIST, Collections.unmodifiableCollection(issueLinkTypes));
        velocityParams.put("linkUtil", new LinkUtil());
        List<Field> fields = this.fieldCollectionsUtils.getCopyToFields();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            fieldMap.put(field.getId(), field);
        }
        velocityParams.put(FIELD_LIST, Collections.unmodifiableList(fields));
        velocityParams.put(FIELD_MAP, fieldMap);
        ListOrderedMap projectRoleMap = new ListOrderedMap();
        projectRoleMap.put((Object)"", (Object)"");
        for (ProjectRole projectRole : this.projectRoleManager.getProjectRoles()) {
            projectRoleMap.put((Object)projectRole.getId().toString(), (Object)projectRole.getName());
        }
        velocityParams.put("projectroles", projectRoleMap);
        HashMap<String, FieldAction> hashMap = new HashMap<String, FieldAction>();
        hashMap.put("summary", new FieldAction("template", "CLONE - <%=issue.get(\"summary\")%>"));
        velocityParams.put(FIELDS_TO_SET, hashMap);
        velocityParams.put(COMMENT_TYPE, "template");
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = null;
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        functionDescriptor = (FunctionDescriptor)descriptor;
        velocityParams.put(PROJECT_KEY, functionDescriptor.getArgs().get(PROJECT_KEY));
        velocityParams.put(CALCULATED_PROJECT_KEY, Utils.decodeTemplate((String)functionDescriptor.getArgs().get(CALCULATED_PROJECT_KEY)));
        String issueTypeId = (String)functionDescriptor.getArgs().get(ISSUETYPE);
        velocityParams.put(ISSUETYPE, issueTypeId);
        IssueType issueType = this.issueTypeManager.getIssueType(issueTypeId);
        velocityParams.put("issueTypeName", issueType.getName());
        if (issueType.isSubTask()) {
            velocityParams.put(PARENT_ISSUE_TYPE, functionDescriptor.getArgs().get(PARENT_ISSUE_TYPE));
            velocityParams.put(CALCULATED_PARENT_ISSUE, Utils.decodeTemplate((String)functionDescriptor.getArgs().get(CALCULATED_PARENT_ISSUE)));
        }
        velocityParams.put(RUN_AS_USER, functionDescriptor.getArgs().get(RUN_AS_USER));
        String fieldsToSetJSON = Utils.decodeTemplate((String)functionDescriptor.getArgs().get(FIELDS_TO_SET));
        try {
            velocityParams.put(FIELDS_TO_SET, new ObjectMapper().readValue(fieldsToSetJSON, FieldsToSet.class));
        }
        catch (IOException e) {
            this.log.error("Invalid fields to set option: " + fieldsToSetJSON, (Throwable)e);
            velocityParams.put(FIELDS_TO_SET, Collections.EMPTY_MAP);
        }
        List<Field> fields = this.fieldCollectionsUtils.getCopyToFields();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field f : fields) {
            fieldMap.put(f.getId(), f);
        }
        velocityParams.put(FIELD_LIST, Collections.unmodifiableList(fields));
        velocityParams.put(FIELD_MAP, fieldMap);
        velocityParams.put(COMMENT_ISSUE, functionDescriptor.getArgs().get(COMMENT_ISSUE));
        String valueType = (String)functionDescriptor.getArgs().get(COMMENT_TYPE);
        velocityParams.put(COMMENT_TYPE, valueType);
        velocityParams.put(COMMENT, Utils.decodeTemplate((String)functionDescriptor.getArgs().get(COMMENT)));
        velocityParams.put(SEND_NOTIF, functionDescriptor.getArgs().get(SEND_NOTIF));
        velocityParams.put(RESTRICT_TO_GROUP, functionDescriptor.getArgs().get(RESTRICT_TO_GROUP));
        String id = (String)functionDescriptor.getArgs().get(RESTRICT_TO_ROLE);
        if (StringUtils.isNotBlank(id)) {
            Long longId = new Long(id);
            ProjectRole projectRole = this.projectRoleManager.getProjectRole(longId);
            velocityParams.put(RESTRICT_TO_ROLE, id);
            if (projectRole != null) {
                velocityParams.put(RESTRICT_TO_ROLE_NAME, projectRole.getName());
            }
        } else {
            velocityParams.put(RESTRICT_TO_ROLE, "");
        }
        velocityParams.put(RESTRICT_TO_INTERNAL, functionDescriptor.getArgs().get(RESTRICT_TO_INTERNAL));
        String selectedLinkType = (String)functionDescriptor.getArgs().get(SELECTED_LINK_TYPE);
        velocityParams.put(SELECTED_LINK_TYPE, selectedLinkType);
        if (!com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils.isBlank((String)selectedLinkType)) {
            boolean isInwardLink = selectedLinkType.split(":")[0].equalsIgnoreCase(INWARD);
            try {
                Long linkTypeId = new Long(Long.parseLong(selectedLinkType.split(":")[1]));
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(linkTypeId, false);
                if (issueLinkType == null) {
                    velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
                } else {
                    velocityParams.put(LINK_TYPE_NAME, isInwardLink ? issueLinkType.getInward() : issueLinkType.getOutward());
                }
            }
            catch (NumberFormatException e) {
                velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
            }
        }
        velocityParams.put("linkUtil", new LinkUtil());
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map velocityParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put(PROJECT_KEY, this.extractSingleParam(velocityParams, PROJECT_KEY));
        }
        catch (Exception e) {
            params.put(PROJECT_KEY, SAME_AS_CURRENT_ISSUE);
        }
        try {
            params.put(CALCULATED_PROJECT_KEY, Utils.encodeTemplate(this.extractSingleParam(velocityParams, CALCULATED_PROJECT_KEY)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            params.put(ISSUETYPE, this.extractSingleParam(velocityParams, ISSUETYPE));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            params.put(PARENT_ISSUE_TYPE, this.extractSingleParam(velocityParams, PARENT_ISSUE_TYPE));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            params.put(CALCULATED_PARENT_ISSUE, Utils.encodeTemplate(this.extractSingleParam(velocityParams, CALCULATED_PARENT_ISSUE)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            params.put(SELECTED_LINK_TYPE, this.extractSingleParam(velocityParams, SELECTED_LINK_TYPE));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            params.put(FIELDS_TO_SET, Utils.encodeTemplate(this.extractSingleParam(velocityParams, FIELDS_TO_SET)));
        }
        catch (Exception e) {
            params.put(FIELDS_TO_SET, "{}");
        }
        try {
            params.put(COMMENT_ISSUE, this.extractSingleParam(velocityParams, COMMENT_ISSUE));
        }
        catch (Exception e) {
            params.put(COMMENT_ISSUE, "no");
        }
        try {
            params.put(COMMENT_TYPE, this.extractSingleParam(velocityParams, COMMENT_TYPE));
        }
        catch (IllegalArgumentException e) {
            params.put(COMMENT_TYPE, RAW_VALUE);
        }
        try {
            params.put(COMMENT, Utils.encodeTemplate(this.extractSingleParam(velocityParams, COMMENT)));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put(SEND_NOTIF, this.extractSingleParam(velocityParams, SEND_NOTIF));
        }
        catch (IllegalArgumentException e) {
            params.put(SEND_NOTIF, "no");
        }
        try {
            params.put(RESTRICT_TO_GROUP, this.extractSingleParam(velocityParams, RESTRICT_TO_GROUP));
        }
        catch (IllegalArgumentException e) {
            params.remove(RESTRICT_TO_GROUP);
        }
        try {
            params.put(RESTRICT_TO_ROLE, this.extractSingleParam(velocityParams, RESTRICT_TO_ROLE));
        }
        catch (IllegalArgumentException e) {
            params.remove(RESTRICT_TO_ROLE);
        }
        try {
            params.put(RESTRICT_TO_INTERNAL, this.extractSingleParam(velocityParams, RESTRICT_TO_INTERNAL));
        }
        catch (IllegalArgumentException e) {
            params.put(RESTRICT_TO_INTERNAL, "no");
        }
        try {
            params.put(RUN_AS_USER, this.extractSingleParam(velocityParams, RUN_AS_USER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        params.putAll(super.getDescriptorParams(velocityParams));
        return params;
    }

    @XmlRootElement
    public static class FieldsToSet
    extends HashMap<String, FieldAction> {
    }

    @XmlRootElement
    public static class FieldAction {
        @XmlElement
        public String action;
        @XmlElement
        public String value;

        public FieldAction() {
        }

        public FieldAction(String action, String value) {
            this.action = action;
            this.value = value;
        }

        public String getAction() {
            return this.action;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlRootElement
    public static class IssueTypeDef {
        @XmlElement
        public String id;
        @XmlElement
        public String name;
        @XmlElement
        public Boolean subtask;

        public IssueTypeDef(String id, String name, Boolean subtask) {
            this.id = id;
            this.name = name;
            this.subtask = subtask;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getSubtask() {
            return this.subtask;
        }
    }

    @XmlRootElement
    public static class ProjectDef {
        @XmlElement
        public String key;
        @XmlElement
        public String name;
        @XmlElement
        public List<IssueTypeDef> issueTypes = new ArrayList<IssueTypeDef>();

        public ProjectDef(String key, String name) {
            this.key = key;
            this.name = name;
        }

        public void addIssueType(IssueTypeDef issueTypeDef) {
            this.issueTypes.add(issueTypeDef);
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public List<IssueTypeDef> getIssueTypes() {
            return this.issueTypes;
        }
    }
}

