/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowCopyValueFromOtherFieldPostFunctionPluginFactory
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private final WorkflowUtils workflowUtils;
    private final FieldCollectionsUtils fieldCollectionsUtils;
    static final String IGNORE_EMPTY_VALUE = "ignoreEmptyValue";
    public static final String COPY_ONLY_IF_NOT_SET = "copyOnlyIfNotSet";

    public WorkflowCopyValueFromOtherFieldPostFunctionPluginFactory(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
        this.workflowUtils = workflowUtils;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        List<Field> sourceFields = this.fieldCollectionsUtils.getCopyFromFields();
        List<Field> destinationFields = this.fieldCollectionsUtils.getCopyToFields();
        velocityParams.put("val-sourceFieldsList", Collections.unmodifiableList(sourceFields));
        velocityParams.put("val-destinationFieldsList", Collections.unmodifiableList(destinationFields));
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        Field sourceFieldId = this.workflowUtils.getFieldFromDescriptor(descriptor, "sourceField");
        Field destinationField = this.workflowUtils.getFieldFromDescriptor(descriptor, "destinationField");
        velocityParams.put("val-sourceFieldSelected", sourceFieldId);
        velocityParams.put("val-destinationFieldSelected", destinationField);
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String oldValue = (String)functionDescriptor.getArgs().get("oldValue");
        velocityParams.put("oldValue", oldValue);
        String appendValues = (String)functionDescriptor.getArgs().get("appendValues");
        velocityParams.put("appendValues", appendValues);
        String catenateCascading = (String)functionDescriptor.getArgs().get("catenateCascading");
        velocityParams.put("catenateCascading", catenateCascading);
        velocityParams.put(IGNORE_EMPTY_VALUE, functionDescriptor.getArgs().get(IGNORE_EMPTY_VALUE));
        velocityParams.put(COPY_ONLY_IF_NOT_SET, functionDescriptor.getArgs().get(COPY_ONLY_IF_NOT_SET));
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String sourceField = this.extractSingleParam(conditionParams, "sourceFieldsList");
            String destinationField = this.extractSingleParam(conditionParams, "destinationFieldsList");
            params.put("sourceField", sourceField);
            params.put("destinationField", destinationField);
        }
        catch (IllegalArgumentException sourceField) {
            // empty catch block
        }
        try {
            params.put("oldValue", this.extractSingleParam(conditionParams, "oldValue"));
        }
        catch (IllegalArgumentException iae) {
            params.put("oldValue", "no");
        }
        try {
            params.put("appendValues", this.extractSingleParam(conditionParams, "appendValues"));
        }
        catch (IllegalArgumentException iae) {
            params.put("appendValues", "no");
        }
        try {
            params.put("catenateCascading", this.extractSingleParam(conditionParams, "catenateCascading"));
        }
        catch (IllegalArgumentException iae) {
            params.put("catenateCascading", "no");
        }
        try {
            params.put(IGNORE_EMPTY_VALUE, this.extractSingleParam(conditionParams, IGNORE_EMPTY_VALUE));
        }
        catch (IllegalArgumentException e) {
            params.put(IGNORE_EMPTY_VALUE, "no");
        }
        try {
            params.put(COPY_ONLY_IF_NOT_SET, this.extractSingleParam(conditionParams, COPY_ONLY_IF_NOT_SET));
        }
        catch (IllegalArgumentException e) {
            params.put(COPY_ONLY_IF_NOT_SET, "no");
        }
        params.putAll(super.getDescriptorParams(conditionParams));
        return params;
    }
}

