/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCopyFieldValueFromParentFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private Logger log = LoggerFactory.getLogger(WorkflowCopyFieldValueFromParentFunction.class);
    public static final String FIELD = "field";
    public static final String SELECTED_FIELD = "selectedField";
    public static final String FIELD_LIST = "fieldList";
    public static final String COPY_ONLY_IF_NOT_SET = "copyOnlyIfNotSet";
    static final String APPEND_VALUES = "appendValues";
    static final String IGNORE_EMPTY_VALUE = "ignoreEmptyValue";
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final WorkflowUtils workflowUtils;

    public WorkflowCopyFieldValueFromParentFunction(FieldCollectionsUtils fieldCollectionsUtils, WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.workflowUtils = workflowUtils;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        List<Field> fields = this.fieldCollectionsUtils.getCopyToFields();
        velocityParams.put(FIELD_LIST, Collections.unmodifiableList(fields));
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        velocityParams.put(SELECTED_FIELD, this.workflowUtils.getFieldFromDescriptor(descriptor, FIELD));
        FunctionDescriptor functionDescriptor = null;
        if (!(descriptor instanceof FunctionDescriptor)) {
            IllegalArgumentException exp = new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
            throw exp;
        }
        functionDescriptor = (FunctionDescriptor)descriptor;
        velocityParams.put(COPY_ONLY_IF_NOT_SET, functionDescriptor.getArgs().get(COPY_ONLY_IF_NOT_SET));
        velocityParams.put(APPEND_VALUES, functionDescriptor.getArgs().get(APPEND_VALUES));
        velocityParams.put(IGNORE_EMPTY_VALUE, functionDescriptor.getArgs().get(IGNORE_EMPTY_VALUE));
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String sourceField = this.extractSingleParam(conditionParams, FIELD);
            params.put(FIELD, sourceField);
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put(COPY_ONLY_IF_NOT_SET, this.extractSingleParam(conditionParams, COPY_ONLY_IF_NOT_SET));
        }
        catch (IllegalArgumentException e) {
            params.put(COPY_ONLY_IF_NOT_SET, "no");
        }
        try {
            params.put(APPEND_VALUES, this.extractSingleParam(conditionParams, APPEND_VALUES));
        }
        catch (IllegalArgumentException e) {
            params.put(APPEND_VALUES, "no");
        }
        try {
            params.put(IGNORE_EMPTY_VALUE, this.extractSingleParam(conditionParams, IGNORE_EMPTY_VALUE));
        }
        catch (IllegalArgumentException e) {
            params.put(IGNORE_EMPTY_VALUE, "no");
        }
        params.putAll(super.getDescriptorParams(conditionParams));
        return params;
    }
}

