/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.innovalog.jmwe.plugins.functions.LinkUtil;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCommentLinkedIssuesFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    public static final String VALUE = "value";
    public static final String RAW_VALUE = "rawValue";
    private Logger log = LoggerFactory.getLogger(WorkflowCommentLinkedIssuesFunction.class);
    public static final String VALUE_TYPE = "valueType";
    public static final String SEND_NOTIF = "sendNotification";
    private static final String LINK_TYPE_NAME = "linkTypeName";
    private static final String LINK_TYPES_LIST = "linkTypeList";
    static final String SELECTED_LINK_TYPE = "selectedLinkType";
    static final String INWARD = "inward";
    static final String RUN_AS_USER = "runAsUser";
    public static final String RESTRICT_TO_GROUP = "restrictToGroup";
    public static final String RESTRICT_TO_ROLE = "restrictToProjectRole";
    public static final String RESTRICT_TO_ROLE_NAME = "restrictToProjectRoleName";
    public static final String RESTRICT_TO_INTERNAL = "restrictToInternal";
    public static final String PROJECT_ROLES = "projectroles";
    private final ProjectRoleManager projectRoleManager;
    private final IssueLinkTypeManager issueLinkTypeManager;

    public WorkflowCommentLinkedIssuesFunction(ThirdPartyPluginLicenseStorageManager licenseManager, ProjectRoleManager projectRoleManager, IssueLinkTypeManager issueLinkTypeManager) {
        super(licenseManager);
        this.projectRoleManager = projectRoleManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        velocityParams.put(VALUE_TYPE, "template");
        Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypes(false);
        velocityParams.put(LINK_TYPES_LIST, Collections.unmodifiableCollection(issueLinkTypes));
        ListOrderedMap projectRoleMap = new ListOrderedMap();
        projectRoleMap.put((Object)"", (Object)"");
        for (ProjectRole projectRole : this.projectRoleManager.getProjectRoles()) {
            projectRoleMap.put((Object)projectRole.getId().toString(), (Object)projectRole.getName());
        }
        velocityParams.put(PROJECT_ROLES, projectRoleMap);
        velocityParams.put("linkUtil", new LinkUtil());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = null;
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        functionDescriptor = (FunctionDescriptor)descriptor;
        String valueType = (String)functionDescriptor.getArgs().get(VALUE_TYPE);
        velocityParams.put(VALUE_TYPE, valueType);
        velocityParams.put(VALUE, Utils.decodeTemplate((String)functionDescriptor.getArgs().get(VALUE)));
        velocityParams.put(RUN_AS_USER, functionDescriptor.getArgs().get(RUN_AS_USER));
        velocityParams.put(SEND_NOTIF, functionDescriptor.getArgs().get(SEND_NOTIF));
        String selectedLinkType = (String)functionDescriptor.getArgs().get(SELECTED_LINK_TYPE);
        velocityParams.put(SELECTED_LINK_TYPE, selectedLinkType);
        if (!com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils.isBlank((String)selectedLinkType)) {
            boolean isInwardLink = selectedLinkType.split(":")[0].equalsIgnoreCase(INWARD);
            try {
                Long linkTypeId = new Long(Long.parseLong(selectedLinkType.split(":")[1]));
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(linkTypeId, false);
                if (issueLinkType == null) {
                    velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
                } else {
                    velocityParams.put(LINK_TYPE_NAME, isInwardLink ? issueLinkType.getInward() : issueLinkType.getOutward());
                }
            }
            catch (NumberFormatException e) {
                velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
            }
        }
        velocityParams.put(RESTRICT_TO_GROUP, functionDescriptor.getArgs().get(RESTRICT_TO_GROUP));
        String id = (String)functionDescriptor.getArgs().get(RESTRICT_TO_ROLE);
        if (StringUtils.isNotBlank(id)) {
            Long longId = new Long(id);
            ProjectRole projectRole = this.projectRoleManager.getProjectRole(longId);
            velocityParams.put(RESTRICT_TO_ROLE, id);
            if (projectRole != null) {
                velocityParams.put(RESTRICT_TO_ROLE_NAME, projectRole.getName());
            }
        } else {
            velocityParams.put(RESTRICT_TO_ROLE, "");
        }
        velocityParams.put(RESTRICT_TO_INTERNAL, functionDescriptor.getArgs().get(RESTRICT_TO_INTERNAL));
        velocityParams.put("linkUtil", new LinkUtil());
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put(SELECTED_LINK_TYPE, this.extractSingleParam(conditionParams, SELECTED_LINK_TYPE));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put(VALUE_TYPE, this.extractSingleParam(conditionParams, VALUE_TYPE));
        }
        catch (IllegalArgumentException e) {
            params.put(VALUE_TYPE, RAW_VALUE);
        }
        try {
            params.put(VALUE, Utils.encodeTemplate(this.extractSingleParam(conditionParams, VALUE)));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put(RUN_AS_USER, this.extractSingleParam(conditionParams, RUN_AS_USER));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            params.put(SEND_NOTIF, this.extractSingleParam(conditionParams, SEND_NOTIF));
        }
        catch (IllegalArgumentException e) {
            params.put(SEND_NOTIF, "no");
        }
        try {
            params.put(RESTRICT_TO_GROUP, this.extractSingleParam(conditionParams, RESTRICT_TO_GROUP));
        }
        catch (IllegalArgumentException e) {
            params.remove(SEND_NOTIF);
        }
        try {
            params.put(RESTRICT_TO_ROLE, this.extractSingleParam(conditionParams, RESTRICT_TO_ROLE));
        }
        catch (IllegalArgumentException e) {
            params.remove(RESTRICT_TO_ROLE);
        }
        try {
            params.put(RESTRICT_TO_INTERNAL, this.extractSingleParam(conditionParams, RESTRICT_TO_INTERNAL));
        }
        catch (IllegalArgumentException e) {
            params.put(RESTRICT_TO_INTERNAL, "no");
        }
        params.putAll(super.getDescriptorParams(conditionParams));
        return params;
    }
}

