/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowAddFieldValueToParentFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private Logger log = LoggerFactory.getLogger(WorkflowAddFieldValueToParentFunction.class);
    public static final String FIELD = "field";
    public static final String SELECTED_FIELD = "selectedField";
    public static final String FIELD_LIST = "fieldList";
    private final WorkflowUtils workflowUtils;
    private final FieldCollectionsUtils fieldCollectionsUtils;

    public WorkflowAddFieldValueToParentFunction(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
        this.workflowUtils = workflowUtils;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        List<Field> fields = this.fieldCollectionsUtils.getCopyToMultiFields();
        velocityParams.put(FIELD_LIST, Collections.unmodifiableList(fields));
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        velocityParams.put(SELECTED_FIELD, this.workflowUtils.getFieldFromDescriptor(descriptor, FIELD));
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String sourceField = this.extractSingleParam(conditionParams, FIELD);
            params.put(FIELD, sourceField);
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        params.putAll(super.getDescriptorParams(conditionParams));
        return params;
    }
}

