/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SetFieldValueOfLinkedIssuesFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private final IssueLinkManager issueLinkManager;
    private final UserManager userManager;
    private final ScriptManager scriptManager;

    public SetFieldValueOfLinkedIssuesFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, FieldValueService fieldValueService, IssueLinkManager issueLinkManager, UserManager userManager, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
        this.issueLinkManager = issueLinkManager;
        this.userManager = userManager;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        Long linkTypeId;
        String fieldKey = (String)args.get("field");
        String rawLinkType = (String)args.get("selectedLinkType");
        boolean appendValues = "yes".equalsIgnoreCase((String)args.get("appendValues"));
        boolean ignoreEmptyValue = "yes".equalsIgnoreCase((String)args.get("ignoreEmptyValue"));
        if (StringUtils.isBlank(rawLinkType) || rawLinkType.split(":").length != 2) {
            throw new IllegalArgumentException("SetFieldValueOfLinkedIssuesFunction is not configured with a valid link type ID.");
        }
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("SetFieldValueOfLinkedIssuesFunction not configured with a valid link type ID: ").append(rawLinkType).append(" can not be parsed.").toString());
        }
        Field field = this.workflowUtils.getFieldFromKey(fieldKey);
        if (field == null) {
            throw new IllegalArgumentException("Error while executing function : field [" + fieldKey + "] not found");
        }
        MutableIssue issue = this.getIssue(transientVars);
        String value = Utils.decodeTemplate((String)args.get("value"));
        boolean useGroovy = "expression".equals(args.get("valueType"));
        boolean useTemplate = "template".equals(args.get("valueType"));
        GroovyExpression groovyExpression = null;
        if (useGroovy || useTemplate) {
            groovyExpression = new GroovyExpression(value, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            groovyExpression.addIssueVariable("issue", (Issue)issue);
        }
        List links = isInwardLink ? this.issueLinkManager.getInwardLinks(issue.getId()) : this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink issueLink : links) {
            FieldValueHolder newValue;
            if (!issueLink.getLinkTypeId().equals(linkTypeId)) continue;
            Issue linkedIssue = isInwardLink ? issueLink.getSourceObject() : issueLink.getDestinationObject();
            Object currentValue = this.fieldValueService.getFieldValueFromIssue(linkedIssue, field, true);
            GroovyExpression groovyCondition = this.groovyCondition(transientVars, args, ps);
            if (groovyCondition != null && !((Boolean)groovyCondition.addIssueVariable("linkedIssue", linkedIssue).addVariable("currentValue", currentValue).eval(this.workflowUtils, this.fieldValueService)).booleanValue() || currentValue != null && (!(currentValue instanceof Collection) || !((Collection)currentValue).isEmpty()) && !appendValues && args.get("copyOnlyIfNotSet") != null && ((String)args.get("copyOnlyIfNotSet")).equalsIgnoreCase("yes")) continue;
            MutableIssue modifiedIssue = this.issueManager.getIssueObject(linkedIssue.getId());
            DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
            if (useGroovy || useTemplate) {
                groovyExpression.addIssueVariable("linkedIssue", (Issue)modifiedIssue);
                groovyExpression.addVariable("currentValue", currentValue);
                Object res = useGroovy ? groovyExpression.eval(this.workflowUtils, this.fieldValueService) : groovyExpression.evalTemplate(this.workflowUtils, this.fieldValueService);
                newValue = this.fieldValueService.createFieldValueHolderFomGroovyResult(res, fieldKey);
                groovyExpression.addIssueVariable("linkedIssue", null);
                groovyExpression.addVariable("currentValue", null);
            } else {
                newValue = new FieldValueHolder(value);
            }
            if (ignoreEmptyValue && newValue.isEmpty()) continue;
            this.fieldValueService.setFieldValue(modifiedIssue, field, newValue, appendValues ? currentValue : null, (IssueChangeHolder)changeHolder, false);
            ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
            if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
                runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
            }
            this.updateIssue(modifiedIssue, changeHolder.getChangeItems(), runAsUser, true, true);
        }
    }
}

