/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collection;
import java.util.Map;

public class SetFieldValueFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private final ScriptManager scriptManager;

    public SetFieldValueFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        String fieldKey = (String)args.get("field");
        boolean appendValues = "yes".equalsIgnoreCase((String)args.get("appendValues"));
        boolean ignoreEmptyValue = "yes".equalsIgnoreCase((String)args.get("ignoreEmptyValue"));
        Field field = this.workflowUtils.getFieldFromKey(fieldKey);
        if (field == null) {
            throw new IllegalArgumentException("Error while executing function : field [" + fieldKey + "] not found");
        }
        MutableIssue issue = this.getIssue(transientVars);
        Object currentValue = this.fieldValueService.getFieldValueFromIssue((Issue)issue, field, true);
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.addVariable("currentValue", currentValue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        String value = Utils.decodeTemplate((String)args.get("value"));
        boolean useGroovy = "expression".equals(args.get("valueType"));
        boolean useTemplate = "template".equals(args.get("valueType"));
        if (currentValue == null || currentValue instanceof Collection && ((Collection)currentValue).isEmpty() || appendValues || args.get("copyOnlyIfNotSet") == null || !((String)args.get("copyOnlyIfNotSet")).equalsIgnoreCase("yes")) {
            FieldValueHolder newValue;
            if (useGroovy || useTemplate) {
                GroovyExpression expression = new GroovyExpression(value, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
                expression.addIssueVariable("issue", (Issue)issue);
                expression.addVariable("currentValue", currentValue);
                Object res = useGroovy ? expression.eval(this.workflowUtils, this.fieldValueService) : expression.evalTemplate(this.workflowUtils, this.fieldValueService);
                newValue = this.fieldValueService.createFieldValueHolderFomGroovyResult(res, fieldKey);
            } else {
                newValue = new FieldValueHolder(value);
            }
            if (ignoreEmptyValue && newValue.isEmpty()) {
                return;
            }
            this.fieldValueService.setFieldValue(issue, field, newValue, appendValues ? currentValue : null, (IssueChangeHolder)holder, false);
            if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
                this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
            }
        }
    }
}

