/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.groovy.SearchHelper;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LinkIssuesFunction
extends AbstractPreserveChangesPostFunction {
    private final IssueLinkManager issueLinkManager;
    private final FieldValueService fieldValueService;
    private final SearchHelper searchHelper;
    private final UserManager userManager;
    private final ScriptManager scriptManager;

    public LinkIssuesFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, IssueLinkManager issueLinkManager, FieldValueService fieldValueService, PreferencesService preferencesService, SearchHelper searchHelper, UserManager userManager, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.issueLinkManager = issueLinkManager;
        this.fieldValueService = fieldValueService;
        this.searchHelper = searchHelper;
        this.userManager = userManager;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) {
        Long linkTypeId;
        MutableIssue issue = this.getIssue(transientVars);
        String rawLinkType = (String)args.get("selectedLinkType");
        String jql = Utils.decodeTemplate((String)args.get("jql"));
        Integer maxIssues = Integer.parseInt((String)args.get("maxIssues"));
        if (StringUtils.isBlank(rawLinkType) || rawLinkType.split(":").length != 2) {
            throw new IllegalArgumentException("LinkIssuesFunction is not configured with a valid link type ID.");
        }
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("LinkIssuesFunction not configured with a valid link type ID: ").append(rawLinkType).append(" can not be parsed.").toString());
        }
        ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
        if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
            runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
        }
        GroovyExpression expression = new GroovyExpression(jql, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
        expression.addIssueVariable("issue", (Issue)issue);
        String realJql = expression.evalTemplate(this.workflowUtils, this.fieldValueService);
        SearchResults searchResults = this.searchHelper.search(runAsUser, realJql, maxIssues);
        for (Issue candidateIssue : searchResults.getIssues()) {
            if (candidateIssue.getKey().equals(issue.getKey())) {
                this.log.warn("Cannot link issue " + issue.getKey() + " to itself. Skipping.");
                continue;
            }
            GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
            if (groovyExpression != null && !((Boolean)groovyExpression.addVariable("linkedIssue", candidateIssue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) continue;
            try {
                this.createIssueLink(issue.getId(), candidateIssue.getId(), linkTypeId, 0L, runAsUser);
            }
            catch (CreateException e) {
                throw new WorkflowException("Could not create issue link between " + issue.getKey() + " and " + candidateIssue.getKey(), (Throwable)e);
            }
        }
    }

    private void createIssueLink(Long sourceIssueId, Long destinationIssueId, Long issueLinkTypeId, Long sequence, ApplicationUser remoteUser) throws CreateException {
        try {
            Method createIssueLink = this.issueLinkManager.getClass().getMethod("createIssueLink", Long.class, Long.class, Long.class, Long.class, ApplicationUser.class);
            createIssueLink.invoke((Object)this.issueLinkManager, sourceIssueId, destinationIssueId, issueLinkTypeId, sequence, remoteUser);
        }
        catch (NoSuchMethodException e) {
            Method createIssueLink = null;
            try {
                createIssueLink = this.issueLinkManager.getClass().getMethod("createIssueLink", Long.class, Long.class, Long.class, Long.class, User.class);
                createIssueLink.invoke((Object)this.issueLinkManager, sourceIssueId, destinationIssueId, issueLinkTypeId, sequence, UserCompatibilityHelper.getUserForKey(remoteUser.getKey()));
            }
            catch (Exception e1) {
                throw new IllegalStateException(e);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

