/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;

public class IncreaseFieldValueFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private static final String FIELD = "field";

    public IncreaseFieldValueFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        String fieldKey = (String)args.get(FIELD);
        Field field = this.workflowUtils.getFieldFromKey(fieldKey);
        if (field == null) {
            throw new IllegalArgumentException("Error while executing function : field [" + fieldKey + "] not found");
        }
        MutableIssue issue = this.getIssue(transientVars);
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        FieldValueHolder sourceValue = this.fieldValueService.createFieldValueHolder((Issue)issue, fieldKey);
        if (!sourceValue.isEmpty()) {
            if (!sourceValue.isSingleValue() || !(sourceValue.getFirstValueOrNull() instanceof Double)) throw new IllegalArgumentException("Increase Field Value post-function only operates on Numeric fields.");
            sourceValue = new FieldValueHolder((Double)sourceValue.getFirstValueOrNull() + 1.0);
            this.fieldValueService.setFieldValue(issue, field, sourceValue, null, (IssueChangeHolder)holder, false);
            if (!this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) return;
            this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
            return;
        } else {
            Double newValueDbl = new Double(1.0);
            this.fieldValueService.setFieldValue(issue, field, new FieldValueHolder(1.0), null, (IssueChangeHolder)holder, false);
            if (!this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) return;
            this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
        }
    }
}

