/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CopyFieldValueFromLinkedIssueFunction
extends AbstractPreserveChangesPostFunction {
    private static final String INWARD = "inward";
    private static final String FIELD = "field";
    private final IssueLinkManager issueLinkManager;
    private final FieldValueService fieldValueService;

    public CopyFieldValueFromLinkedIssueFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, IssueLinkManager issueLinkManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.issueLinkManager = issueLinkManager;
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) {
        Long linkTypeId;
        String fieldKey = (String)args.get(FIELD);
        String rawLinkType = (String)args.get("selectedLinkType");
        boolean appendValues = "yes".equalsIgnoreCase((String)args.get("appendValues"));
        boolean ignoreEmptyValue = "yes".equalsIgnoreCase((String)args.get("ignoreEmptyValue"));
        if (StringUtils.isBlank(rawLinkType) || rawLinkType.split(":").length != 2) {
            throw new IllegalArgumentException("CopyFieldValueFromLinkedIssueFunction is not configured with a valid link type ID.");
        }
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase(INWARD);
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("CopyFieldValueFromLinkedIssueFunction not configured with a valid link type ID: ").append(rawLinkType).append(" can not be parsed.").toString());
        }
        Field field = this.workflowUtils.getFieldFromKey(fieldKey);
        if (field == null) {
            throw new IllegalArgumentException("Error while executing function : field [" + fieldKey + "] not found");
        }
        MutableIssue issue = this.getIssue(transientVars);
        Object currentValue = this.fieldValueService.getFieldValueFromIssue((Issue)issue, field, true);
        if (currentValue == null || currentValue instanceof Collection && ((Collection)currentValue).isEmpty() || appendValues || args.get("copyOnlyIfNotSet") == null || !((String)args.get("copyOnlyIfNotSet")).equalsIgnoreCase("yes")) {
            List links = isInwardLink ? this.issueLinkManager.getInwardLinks(issue.getId()) : this.issueLinkManager.getOutwardLinks(issue.getId());
            FieldValueHolder sourceValue = null;
            for (IssueLink issueLink : links) {
                if (!issueLink.getLinkTypeId().equals(linkTypeId)) continue;
                Issue linkedIssue = isInwardLink ? issueLink.getSourceObject() : issueLink.getDestinationObject();
                FieldValueHolder valueHolder = this.fieldValueService.createFieldValueHolder(linkedIssue, fieldKey);
                GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
                if (groovyExpression != null && !((Boolean)groovyExpression.addIssueVariable("linkedIssue", linkedIssue).addVariable("currentValue", currentValue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) continue;
                if (sourceValue == null) {
                    sourceValue = valueHolder;
                    if (!valueHolder.isSingleValue()) continue;
                    break;
                }
                sourceValue.append(valueHolder);
            }
            if (!(sourceValue == null || ignoreEmptyValue && sourceValue.isEmpty())) {
                this.fieldValueService.setFieldValue(issue, field, sourceValue, appendValues ? currentValue : null, (IssueChangeHolder)holder, false);
                if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
                    this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
                }
            }
        }
    }
}

