/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommentLinkedIssuesFunction
extends AbstractPreserveChangesPostFunction {
    private final CommentManager commentManager;
    private final IssueLinkManager issueLinkManager;
    private final UserManager userManager;
    private final FieldValueService fieldValueService;
    private final ScriptManager scriptManager;

    public CommentLinkedIssuesFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, CommentManager commentManager, IssueLinkManager issueLinkManager, UserManager userManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.commentManager = commentManager;
        this.issueLinkManager = issueLinkManager;
        this.userManager = userManager;
        this.fieldValueService = fieldValueService;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) {
        Long linkTypeId;
        boolean sendNotification = "yes".equalsIgnoreCase((String)args.get("sendNotification"));
        MutableIssue issue = this.getIssue(transientVars);
        String rawLinkType = (String)args.get("selectedLinkType");
        if (StringUtils.isBlank(rawLinkType) || rawLinkType.split(":").length != 2) {
            throw new IllegalArgumentException("CommentLinkedIssuesFunction is not configured with a valid link type ID.");
        }
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("CommentLinkedIssuesFunction not configured with a valid link type ID: ").append(rawLinkType).append(" can not be parsed.").toString());
        }
        List links = isInwardLink ? this.issueLinkManager.getInwardLinks(issue.getId()) : this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink issueLink : links) {
            if (!issueLink.getLinkTypeId().equals(linkTypeId)) continue;
            Issue linkedIssue = isInwardLink ? issueLink.getSourceObject() : issueLink.getDestinationObject();
            GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
            if (groovyExpression != null && !((Boolean)groovyExpression.addIssueVariable("linkedIssue", linkedIssue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) continue;
            try {
                String restrictToGroup;
                String commentString;
                String value = Utils.decodeTemplate((String)args.get("value"));
                boolean useGroovy = "expression".equals(args.get("valueType"));
                boolean useTemplate = "template".equals(args.get("valueType"));
                if (useGroovy || useTemplate) {
                    GroovyExpression expression = new GroovyExpression(value, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
                    expression.addIssueVariable("issue", (Issue)issue);
                    expression.addIssueVariable("linkedIssue", linkedIssue);
                    commentString = useGroovy ? (String)expression.eval(this.workflowUtils, this.fieldValueService) : expression.evalTemplate(this.workflowUtils, this.fieldValueService);
                } else {
                    commentString = value;
                }
                if (commentString == null || StringUtils.isBlank(commentString = commentString.trim())) continue;
                ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
                if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
                    runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
                }
                if (StringUtils.isBlank(restrictToGroup = (String)args.get("restrictToGroup"))) {
                    restrictToGroup = null;
                }
                String restrictToRoleIDStr = (String)args.get("restrictToProjectRole");
                Long restrictToRoleID = null;
                if (StringUtils.isNotBlank(restrictToRoleIDStr)) {
                    restrictToRoleID = Long.parseLong(restrictToRoleIDStr);
                }
                boolean restrictToInternal = "yes".equalsIgnoreCase((String)args.get("restrictToInternal"));
                HashMap<String, JSONObject> commentProperties = null;
                if (restrictToInternal) {
                    commentProperties = new HashMap<String, JSONObject>();
                    commentProperties.put("sd.public.comment", new JSONObject("{internal:true}"));
                }
                this.commentManager.create(linkedIssue, runAsUser, commentString, restrictToGroup, restrictToRoleID, new Date(), commentProperties, sendNotification);
            }
            catch (Exception e) {
                if (this.preferencesService.isThrowExceptions().booleanValue()) {
                    throw new IllegalArgumentException("Error in CommentLinkedIssuesFunction while attempting to add comment to issue " + linkedIssue.getKey() + ". Skipping. Error: " + e, e);
                }
                this.log.warn("Error in CommentLinkedIssuesFunction while attempting to add comment to issue " + linkedIssue.getKey() + ". Skipping. Error: " + e, (Throwable)e);
            }
        }
    }
}

