/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ServletActionContext;

public class AssignToLastRoleMemberFunction
extends AbstractPreserveChangesPostFunction {
    private final UserManager userManager;
    private final ProjectRoleManager projectRoleManager;
    private final FieldValueService fieldValueService;

    public AssignToLastRoleMemberFunction(UserManager userManager, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, WorkflowUtils workflowUtils, ProjectRoleManager projectRoleManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.userManager = userManager;
        this.projectRoleManager = projectRoleManager;
        this.fieldValueService = fieldValueService;
    }

    @Override
    protected void executeFunction(Map<String, Object> transientVars, Map<String, String> args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        String[] assigneeSelected;
        MutableIssue issue = (MutableIssue)transientVars.get("issue");
        boolean skipInactiveUsers = args.get("skipInactiveUsers") != null && args.get("skipInactiveUsers").equalsIgnoreCase("yes");
        HttpServletRequest request = ServletActionContext.getRequest();
        String selectedAssigneeName = "-1";
        if (request != null && (assigneeSelected = request.getParameterValues("assignee")) != null && assigneeSelected.length > 0 && !(selectedAssigneeName = assigneeSelected[0]).equals("-1") && args.get("skipIfAssignee") != null && args.get("skipIfAssignee").equalsIgnoreCase("yes")) {
            return;
        }
        String issueKey = issue.getKey();
        this.log.debug(issueKey + ": selected assignee name=" + selectedAssigneeName);
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            this.log.info(issueKey + ": skipping because Groovy condition returned false");
            return;
        }
        Long projectRoleId = null;
        String rawprojectRoleId = args.get("jira.projectrole.id");
        if (StringUtils.isBlank(rawprojectRoleId)) {
            throw new IllegalArgumentException("AssignToLastRoleMember not configured with a valid projectroleid.");
        }
        try {
            projectRoleId = new Long(Long.parseLong(rawprojectRoleId));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("AssignToLastRoleMember not configured with a valid projectroleid, the project role id: ").append(projectRoleId).append(" can not be parsed. (no assignment will be made)").toString());
        }
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(projectRoleId);
        if (projectRole == null) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("AssignToLastRoleMember is configured to assign to the last user in project role that doesn't exist: id is ").append(projectRoleId).append(" (no assignment will be made)").toString());
        }
        this.log.debug(issueKey + ": project role=" + projectRole.getName());
        Set users = null;
        Issue originalIssue = (Issue)transientVars.get("originalissueobject");
        if (!selectedAssigneeName.equals("-1") && args.get("forceSelectedUser") != null && args.get("forceSelectedUser").equalsIgnoreCase("yes") && !selectedAssigneeName.equals(originalIssue.getAssigneeId() == null ? "" : originalIssue.getAssigneeId())) {
            ApplicationUser selectedAssigneeUser = this.userManager.getUserByName(selectedAssigneeName.isEmpty() ? null : selectedAssigneeName);
            StringBuilder sb = new StringBuilder();
            sb.append(issueKey);
            sb.append(": forcing assignee to '");
            sb.append(selectedAssigneeUser == null ? "Unassigned" : selectedAssigneeUser.getName());
            sb.append("' (was '");
            sb.append(originalIssue.getAssigneeId() == null ? "Unassigned" : originalIssue.getAssigneeId());
            sb.append("')");
            this.log.debug(sb.toString());
            return;
        }
        ProjectRoleActors actors = this.projectRoleManager.getProjectRoleActors(projectRole, issue.getProjectObject());
        if (actors != null) {
            users = actors.getApplicationUsers();
        }
        ApplicationUser user = null;
        if (users != null) {
            if (args.get("includeCurrentAssignee") != null && args.get("includeCurrentAssignee").equalsIgnoreCase("yes")) {
                String userKey = null;
                if (issue.getModifiedFields().containsKey("assignee")) {
                    ModifiedValue mv = (ModifiedValue)issue.getModifiedFields().get("assignee");
                    if (mv != null) {
                        Object o = mv.getOldValue();
                        if (o instanceof ApplicationUser) {
                            userKey = ((ApplicationUser)o).getKey();
                        } else if (o instanceof User) {
                            userKey = UserCompatibilityHelper.getKeyForUser((User)o);
                        }
                    } else {
                        userKey = issue.getAssigneeId();
                    }
                } else {
                    userKey = issue.getAssigneeId();
                }
                if (userKey != null) {
                    user = this.userManager.getUserByKey(userKey);
                }
                if (user != null && users.contains(user) && (!skipInactiveUsers || user.isActive())) {
                    this.log.debug(issueKey + ": assigning to current assignee (before transition): " + user.getName());
                    if (!user.getName().equals(selectedAssigneeName)) {
                        issue.setAssigneeId(userKey);
                    }
                    return;
                }
            }
            ChangeHistoryManager changeHistoryManager = (ChangeHistoryManager)ComponentManager.getComponentInstanceOfType(ChangeHistoryManager.class);
            List changeHistory = changeHistoryManager.getChangeHistories((Issue)issue);
            ChangeHistory changeHistoryItem = null;
            List changeItemBeans = null;
            for (int i = changeHistory.size() - 1; i >= 0; --i) {
                user = null;
                changeHistoryItem = (ChangeHistory)changeHistory.get(i);
                this.log.debug("history change at " + changeHistoryItem.getTimePerformed().toString());
                changeItemBeans = changeHistoryItem.getChangeItems();
                for (GenericValue change : changeItemBeans) {
                    String changedField = change.getString("field");
                    if (!changedField.equalsIgnoreCase("assignee")) continue;
                    this.log.debug("AssignToLastRoleMember history says assignee was previously " + change.getString("oldvalue"));
                    user = this.userManager.getUserByKey(change.getString("oldvalue"));
                    if (user != null) break;
                    user = this.userManager.getUserByName(change.getString("oldvalue"));
                    break;
                }
                if (user == null || !users.contains(user) || skipInactiveUsers && !user.isActive()) continue;
                this.log.info("AssignToLastRoleMember assigning " + issueKey + " to: " + user.getName());
                if (!user.getName().equals(selectedAssigneeName)) {
                    issue.setAssigneeId(user.getKey());
                }
                return;
            }
            if (args.get("includeReporter") != null && args.get("includeReporter").equalsIgnoreCase("yes")) {
                if (issue.getReporterId() != null) {
                    user = this.userManager.getUserByKey(issue.getReporterId());
                }
                if (user != null && users.contains(user) && (!skipInactiveUsers || user.isActive())) {
                    if (!user.getName().equals(selectedAssigneeName)) {
                        issue.setAssigneeId(issue.getReporterId());
                    }
                    return;
                }
            }
            StringBuffer sb = new StringBuffer();
            this.log.warn(sb.append("AssignToLastRoleMember is configured to assign to the last user in project role ").append(projectRole.getName()).append(". There are was no such user found in the change history. (no assignment will be made)").toString());
            return;
        }
        StringBuffer sb = new StringBuffer();
        this.log.warn(sb.append("AssignToLastRoleMember is configured to assign to the last user in project role ").append(projectRole.getName()).append(". There are no users in that role. (no assignment will be made)").toString());
    }
}

