/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreserveChangesPostFunction
extends AbstractJiraFunctionProvider {
    private static final String CHANGE_ITEMS = "changeItems";
    protected final Logger log;
    protected final WorkflowUtils workflowUtils;
    protected final ThirdPartyPluginLicenseStorageManager licenseManager;
    protected final IssueUpdater issueUpdater;
    protected final IssueManager issueManager;
    protected final BuildUtilsInfo buildUtilsInfo;
    private final IssueIndexManager indexManager;
    protected final PreferencesService preferencesService;
    private final ScriptManager scriptManager;

    protected AbstractPreserveChangesPostFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, WorkflowUtils workflowUtils, PreferencesService preferencesService, ScriptManager scriptManager) {
        this.licenseManager = licenseManager;
        this.issueUpdater = issueUpdater;
        this.issueManager = issueManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.indexManager = indexManager;
        this.workflowUtils = workflowUtils;
        this.preferencesService = preferencesService;
        this.scriptManager = scriptManager;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    protected abstract void executeFunction(Map<String, Object> var1, Map<String, String> var2, PropertySet var3, MyIssueChangeHolder var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        block12: {
            if (!(System.getenv("JMWE_PASS") != null && "81b1efe3ba3500d7061178a9e62a20db".equals(DigestUtils.md5Hex((String)System.getenv("JMWE_PASS"))) || "81b1efe3ba3500d7061178a9e62a20db".equals(DigestUtils.md5Hex((String)AbstractLicensedWorkflowPluginFactory.getFieldDesc("jmwe"))) || this.licenseManager.isOnDemand() && !new Date().after(new Date(117, 2, 1)))) {
                try {
                    if (this.licenseManager.getLicense().isDefined()) {
                        PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                        if (pluginLicense.getError().isDefined()) {
                            this.log.error("Your JIRA Misc Workflow Extensions plugin license has an error: " + ((LicenseError)pluginLicense.getError().get()).name());
                            return;
                        }
                        break block12;
                    }
                    this.log.error("You don't have a JIRA Misc Workflow Extensions plugin license.");
                    return;
                }
                catch (PluginLicenseStoragePluginUnresolvedException e) {
                    this.log.error("Could not find License Storage plugin.");
                    return;
                }
            }
        }
        MyIssueChangeHolder holder = this.createChangeHolder(transientVars);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing function with [transientVars=" + transientVars + ";args=" + args + ";ps=" + ps + "]");
        }
        try {
            this.executeFunction(transientVars, args, ps, holder);
        }
        catch (Exception e) {
            this.log.error("Error while executing " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + e, (Throwable)e);
            if (this.preferencesService.isThrowExceptions().booleanValue()) {
                throw new WorkflowException("Error while executing " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + e, (Throwable)e);
            }
        }
        finally {
            this.releaseChangeHolder((IssueChangeHolder)holder, transientVars);
        }
    }

    private MyIssueChangeHolder createChangeHolder(Map<String, Object> transientVars) {
        LinkedList changeItems = (LinkedList)transientVars.get(CHANGE_ITEMS);
        if (changeItems == null) {
            changeItems = new LinkedList();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new holder with items - " + ((Object)changeItems).toString());
        }
        MyIssueChangeHolder holder = new MyIssueChangeHolder();
        holder.setChangeItems(changeItems);
        return holder;
    }

    private void releaseChangeHolder(IssueChangeHolder holder, Map<String, Object> transientVars) {
        List items = holder.getChangeItems();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Release holder with items - " + items.toString());
        }
        transientVars.put(CHANGE_ITEMS, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIssue(MutableIssue modifiedIssue, Collection<ChangeItemBean> changeItemBeans, ApplicationUser remoteUser, boolean sendNotification, boolean createHistoryEntry) {
        if (this.buildUtilsInfo.getVersionNumbers()[0] == 5 && this.buildUtilsInfo.getVersionNumbers()[1] < 1) {
            boolean indexingPreviouslyEnabled = ImportUtils.isIndexIssues();
            if (!indexingPreviouslyEnabled) {
                ImportUtils.setIndexIssues((boolean)true);
            }
            this.issueManager.updateIssue(remoteUser, modifiedIssue, UpdateIssueRequest.builder().eventDispatchOption(EventDispatchOption.ISSUE_UPDATED).sendMail(sendNotification).build());
            try {
                this.indexManager.reIndex((Issue)modifiedIssue);
            }
            catch (Exception e) {
                this.log.warn("Error while executing function: " + e, (Throwable)e);
            }
            finally {
                if (!indexingPreviouslyEnabled) {
                    ImportUtils.setIndexIssues((boolean)false);
                }
            }
        } else {
            this.issueManager.updateIssue(remoteUser, modifiedIssue, UpdateIssueRequest.builder().eventDispatchOption(EventDispatchOption.ISSUE_UPDATED).sendMail(sendNotification).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexIssue(Issue issue) {
        if (this.buildUtilsInfo.getVersionNumbers()[0] == 5 && this.buildUtilsInfo.getVersionNumbers()[1] < 1) {
            boolean indexingPreviouslyEnabled = ImportUtils.isIndexIssues();
            if (!indexingPreviouslyEnabled) {
                ImportUtils.setIndexIssues((boolean)true);
            }
            try {
                this.indexManager.reIndex(issue);
            }
            catch (Exception e) {
                this.log.warn("Error while indexing issue: " + e, (Throwable)e);
            }
            finally {
                if (!indexingPreviouslyEnabled) {
                    ImportUtils.setIndexIssues((boolean)false);
                }
            }
        } else {
            try {
                this.indexManager.reIndex(issue);
            }
            catch (Exception e) {
                this.log.warn("Error while indexing issue: " + e, (Throwable)e);
            }
        }
    }

    protected GroovyExpression groovyCondition(Map transientVars, Map args, PropertySet ps) {
        if (this.licenseManager.isOnDemand()) {
            return null;
        }
        boolean useGroovyCondition = "yes".equalsIgnoreCase((String)args.get("useGroovyCondition"));
        if (!useGroovyCondition) {
            return null;
        }
        String script = (String)args.get("groovyExpression");
        if (script == null || script.trim().isEmpty()) {
            return null;
        }
        GroovyExpression expression = new GroovyExpression(script, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
        expression.addIssueVariable("issue", (Issue)this.getIssue(transientVars));
        return expression;
    }

    protected boolean shouldUpdateCurrentIssue(Issue issue, Map transientVars, Map args) {
        if (issue.getId() == null) {
            return false;
        }
        Integer actionId = (Integer)transientVars.get("actionId");
        WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)transientVars.get("descriptor");
        ActionDescriptor actionDescriptor = workflowDescriptor.getAction(actionId.intValue());
        List postFunctions = actionDescriptor.getUnconditionalResult().getPostFunctions();
        int currentPostFunctionPos = -1;
        int issueReindexPos = -1;
        int pos = 0;
        String postFunctionKey = (String)args.get("full.module.key");
        String postFunctionClass = (String)args.get("class.name");
        for (FunctionDescriptor postFunction : postFunctions) {
            if (postFunction.getArgs() != null && (postFunctionKey != null && postFunctionKey.equals(postFunction.getArgs().get("full.module.key")) || postFunctionClass != null && postFunctionClass.equals(postFunction.getArgs().get("class.name")))) {
                currentPostFunctionPos = pos;
            } else if (postFunction.getArgs() != null && ("com.atlassian.jira.plugin.system.workflowgeneratechangehistory-function".equals(postFunction.getArgs().get("full.module.key")) || postFunction.getArgs().get("class.name") != null && ((String)postFunction.getArgs().get("class.name")).contains("com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction"))) {
                issueReindexPos = pos;
            }
            ++pos;
        }
        return issueReindexPos < currentPostFunctionPos;
    }
}

