/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.conditions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.conditions.LicensedCondition;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedIssuesStatusCondition
extends LicensedCondition {
    private Logger log = LoggerFactory.getLogger(LinkedIssuesStatusCondition.class);
    private final IssueLinkManager issueLinkManager;

    public LinkedIssuesStatusCondition(ThirdPartyPluginLicenseStorageManager licenseManager, IssueLinkManager issueLinkManager) {
        super(licenseManager);
        this.issueLinkManager = issueLinkManager;
    }

    @Override
    public boolean doPassesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Long linkTypeId;
        Issue issue = (Issue)transientVars.get("issue");
        String rawLinkType = (String)args.get("selectedLinkType");
        String statuses = (String)args.get("statuses");
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            this.log.warn(sb.append("LinkedIssuesStatusCondition not configured with a valid link type ID: ").append(rawLinkType).append(" cannot be parsed.").toString());
            return true;
        }
        List links = isInwardLink ? this.issueLinkManager.getInwardLinks(issue.getId()) : this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink issueLink : links) {
            if (!issueLink.getLinkTypeId().equals(linkTypeId)) continue;
            Issue linkedIssue = isInwardLink ? issueLink.getSourceObject() : issueLink.getDestinationObject();
            boolean inRightStatus = false;
            StringTokenizer st = new StringTokenizer(statuses, ",");
            while (st.hasMoreTokens()) {
                String statusId = st.nextToken();
                if (!linkedIssue.getStatusId().equals(statusId)) continue;
                inRightStatus = true;
                break;
            }
            if (inRightStatus) continue;
            return false;
        }
        return true;
    }
}

