/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.conditions;

import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LicensedCondition
extends AbstractJiraCondition {
    protected final ThirdPartyPluginLicenseStorageManager licenseManager;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public LicensedCondition(ThirdPartyPluginLicenseStorageManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public final boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        block8: {
            if (!(System.getenv("JMWE_PASS") != null && "81b1efe3ba3500d7061178a9e62a20db".equals(DigestUtils.md5Hex((String)System.getenv("JMWE_PASS"))) || "81b1efe3ba3500d7061178a9e62a20db".equals(DigestUtils.md5Hex((String)AbstractLicensedWorkflowPluginFactory.getFieldDesc("jmwe"))) || this.licenseManager.isOnDemand() && !new Date().after(new Date(117, 2, 1)))) {
                try {
                    this.log.debug("Verifying license");
                    if (this.licenseManager.getLicense().isDefined()) {
                        PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                        if (pluginLicense.getError().isDefined()) {
                            this.log.error("Your JIRA Misc Workflow Extensions plugin license has an error: " + ((LicenseError)pluginLicense.getError().get()).name());
                            break block8;
                        }
                        this.log.debug("License is valid");
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Executing Condition with [transientVars=" + transientVars + ";args=" + args + ";ps=" + ps + "]");
                        }
                        return this.doPassesCondition(transientVars, args, ps);
                    }
                    this.log.error("You don't have a JIRA Misc Workflow Extensions plugin license.");
                }
                catch (PluginLicenseStoragePluginUnresolvedException e) {
                    this.log.error("Could not find License Storage plugin.");
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Executing Condition with [transientVars=" + transientVars + ";args=" + args + ";ps=" + ps + "]");
                }
                return this.doPassesCondition(transientVars, args, ps);
            }
        }
        return true;
    }

    protected abstract boolean doPassesCondition(Map var1, Map var2, PropertySet var3) throws WorkflowException;
}

