/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins;

import com.atlassian.jira.issue.Issue;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import java.util.Map;

public class WorkflowContext {
    private String className = null;
    private Integer actionId = null;
    private Issue issue = null;
    private String workflowName = null;

    public WorkflowContext(Map transientVars, Map args, PropertySet ps) {
        SimpleWorkflowEntry workflowEntry = (SimpleWorkflowEntry)transientVars.get("entry");
        if (workflowEntry != null) {
            this.workflowName = workflowEntry.getWorkflowName();
        }
        this.issue = (Issue)transientVars.get("issue");
        this.actionId = (Integer)transientVars.get("actionId");
        String classFN = (String)args.get("class.name");
        if (classFN != null) {
            String[] arr = classFN.split("\\.");
            this.className = arr[arr.length - 1];
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("[");
        if (this.className != null) {
            sb.append("Class:" + this.className);
            first = false;
        }
        if (this.workflowName != null) {
            if (!first) {
                sb.append(" ; ");
            }
            sb.append("Worflow:" + this.workflowName);
            first = false;
        }
        if (this.actionId != null) {
            if (!first) {
                sb.append(" ; ");
            }
            sb.append("Transition:" + this.actionId);
            first = false;
        }
        if (this.issue != null) {
            if (!first) {
                sb.append(" ; ");
            }
            sb.append("Issue:" + this.issue.getKey());
        }
        sb.append("]");
        return sb.toString();
    }
}

