/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.groovy.rest;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.groovy.SearchHelper;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.lang3.StringUtils;

@Path(value="/groovy/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GroovySupportRestApi {
    private final WorkflowUtils workflowUtils;
    private final IssueManager issueManager;
    private final IssueLinkManager issueLinkManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final FieldValueService fieldValueService;
    private final SearchHelper searchHelper;
    private final ScriptManager scriptManager;

    public GroovySupportRestApi(WorkflowUtils workflowUtils, IssueManager issueManager, IssueLinkManager issueLinkManager, GlobalPermissionManager globalPermissionManager, FieldValueService fieldValueService, SearchHelper searchHelper, ScriptManager scriptManager) {
        this.workflowUtils = workflowUtils;
        this.issueManager = issueManager;
        this.issueLinkManager = issueLinkManager;
        this.globalPermissionManager = globalPermissionManager;
        this.fieldValueService = fieldValueService;
        this.searchHelper = searchHelper;
        this.scriptManager = scriptManager;
    }

    @POST
    @Path(value="syntax")
    public Response checkSyntax(SourceCodeInput input) {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (input.getSourceCode() == null) {
            return Response.serverError().build();
        }
        GroovyExpression groovyExpression = new GroovyExpression(input.getSourceCode(), "", this.scriptManager);
        return Response.ok((Object)groovyExpression.checkSyntax()).build();
    }

    @POST
    @Path(value="test")
    public Response testScript(SourceCodeInput input) {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (input.getSourceCode() == null) {
            return Response.serverError().build();
        }
        GroovyExpression groovyExpression = new GroovyExpression(input.getSourceCode(), "", input.getLanguage(), this.scriptManager);
        if (input.getIssueKeys() != null) {
            for (Map.Entry<String, String> keyVal : input.getIssueKeys().entrySet()) {
                if (keyVal.getValue() == null || keyVal.getValue().isEmpty()) {
                    if (keyVal.getKey().equals("issue")) {
                        GroovyExpression.TestResult answer = new GroovyExpression.TestResult();
                        answer.setErrorMessage("You did not provide a value for the " + keyVal.getKey() + " variable.");
                        return Response.ok((Object)answer).build();
                    }
                    groovyExpression.addIssueVariable(keyVal.getKey(), null);
                    continue;
                }
                MutableIssue issue2 = this.issueManager.getIssueByCurrentKey(keyVal.getValue());
                if (issue2 == null) {
                    GroovyExpression.TestResult answer = new GroovyExpression.TestResult();
                    answer.setErrorMessage("Issue " + keyVal.getValue() + " does not exist.");
                    return Response.ok((Object)answer).build();
                }
                groovyExpression.addIssueVariable(keyVal.getKey(), (Issue)issue2);
            }
        }
        Issue issue = (Issue)groovyExpression.getVariable("issue");
        Issue linkedIssue = null;
        try {
            linkedIssue = (Issue)groovyExpression.getVariable("linkedIssue");
        }
        catch (Exception issue2) {
            // empty catch block
        }
        if (issue != null && linkedIssue != null) {
            String linkTypeName = null;
            for (IssueLink issueLink : this.issueLinkManager.getOutwardLinks(issue.getId())) {
                if (!issueLink.getDestinationId().equals(linkedIssue.getId())) continue;
                linkTypeName = issueLink.getIssueLinkType().getOutward();
                break;
            }
            if (linkTypeName == null) {
                for (IssueLink issueLink : this.issueLinkManager.getInwardLinks(issue.getId())) {
                    if (!issueLink.getSourceId().equals(linkedIssue.getId())) continue;
                    linkTypeName = issueLink.getIssueLinkType().getInward();
                    break;
                }
            }
            if (linkTypeName != null) {
                groovyExpression.addVariable("linkTypeName", linkTypeName);
            }
        }
        if (input.getCurrentValue() != null) {
            Issue issueForCurrentVal = (Issue)groovyExpression.getVariable(input.getCurrentValue().getSourceIssue());
            if (issueForCurrentVal == null) {
                groovyExpression.addVariable("currentValue", null);
            } else {
                Field field = this.workflowUtils.getFieldFromKey(input.getCurrentValue().getField());
                if (field == null) {
                    GroovyExpression.TestResult answer = new GroovyExpression.TestResult();
                    answer.setErrorMessage("Field " + input.getCurrentValue().getField() + " does not exist.");
                    return Response.ok((Object)answer).build();
                }
                groovyExpression.addVariable("currentValue", this.fieldValueService.getFieldValueFromIssue(issueForCurrentVal, field, true));
            }
        }
        HashMap<MutableIssue, MyIssueChangeHolder> map = input.isAllowChanges() ? new HashMap<MutableIssue, MyIssueChangeHolder>() : null;
        GroovyExpression.TestResult testResult = groovyExpression.testScript(this.workflowUtils, this.fieldValueService, map);
        if ("jql-groovy-template".equals(input.getLanguage()) && StringUtils.isBlank(testResult.getErrorMessage())) {
            try {
                SearchResults searchResults = this.searchHelper.search(currentUser, testResult.getResultString(), input.getMaxResults() != null ? input.getMaxResults() : 10);
                IssueList issues = new IssueList();
                for (Issue i : searchResults.getIssues()) {
                    issues.addIssueEntry(i.getKey(), i.getSummary());
                }
                testResult.setIssues(issues);
                testResult.setResultType(null);
            }
            catch (IllegalArgumentException e) {
                testResult.setErrorMessage(e.getMessage());
            }
        }
        if (input.isAllowChanges()) {
            for (Map.Entry entry : map.entrySet()) {
                if (!((MyIssueChangeHolder)((Object)entry.getValue())).isChanged()) continue;
                this.issueManager.updateIssue(currentUser, (MutableIssue)entry.getKey(), UpdateIssueRequest.builder().eventDispatchOption(EventDispatchOption.ISSUE_UPDATED).sendMail(false).build());
            }
        }
        return Response.ok((Object)testResult).build();
    }

    @GET
    @Path(value="linkedIssues/{issueKey}")
    public Response getLinkedIssues(@PathParam(value="issueKey") String issueKey, @QueryParam(value="linkTypeId") String linkTypeId, @QueryParam(value="linkDirection") String linkDirection) {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        MutableIssue issue = this.issueManager.getIssueByKeyIgnoreCase(issueKey);
        if (issue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if ("*".equals(linkDirection)) {
            Issue linkedIssue;
            IssueList issueList = new IssueList();
            for (IssueLink issueLink : this.issueLinkManager.getOutwardLinks(issue.getId())) {
                if ("-".equals(linkTypeId) && issueLink.isSystemLink()) continue;
                linkedIssue = issueLink.getDestinationObject();
                issueList.addIssueEntry(linkedIssue.getKey(), linkedIssue.getSummary());
            }
            for (IssueLink issueLink : this.issueLinkManager.getInwardLinks(issue.getId())) {
                if ("-".equals(linkTypeId) && issueLink.isSystemLink()) continue;
                linkedIssue = issueLink.getSourceObject();
                issueList.addIssueEntry(linkedIssue.getKey(), linkedIssue.getSummary());
            }
            return Response.ok((Object)issueList).build();
        }
        try {
            Long linkTypeIdNum = Long.parseLong(linkTypeId);
            List links = linkDirection.equals("outward") ? this.issueLinkManager.getOutwardLinks(issue.getId()) : this.issueLinkManager.getInwardLinks(issue.getId());
            IssueList issueList = new IssueList();
            for (IssueLink issueLink : links) {
                if (!issueLink.getLinkTypeId().equals(linkTypeIdNum)) continue;
                Issue linkedIssue = linkDirection.equals("outward") ? issueLink.getDestinationObject() : issueLink.getSourceObject();
                issueList.addIssueEntry(linkedIssue.getKey(), linkedIssue.getSummary());
            }
            return Response.ok((Object)issueList).build();
        }
        catch (NumberFormatException nfe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @XmlRootElement
    @XmlSeeAlso(value={IssueEntry.class})
    public static class IssueList
    extends ArrayList<IssueEntry> {
        void addIssueEntry(String key, String summary) {
            this.add(new IssueEntry(key, summary));
        }

        @XmlElement(name="linkedIssues")
        public List<IssueEntry> getLinkedIssues() {
            return this;
        }
    }

    @XmlRootElement
    public static class IssueEntry {
        @XmlElement
        private String key;
        @XmlElement
        private String summary;

        public IssueEntry(String key, String summary) {
            this.key = key;
            this.summary = summary;
        }
    }

    @XmlRootElement
    static class ValueDescriptor {
        @XmlElement
        private String field;
        @XmlElement
        private String sourceIssue;

        private ValueDescriptor() {
        }

        public String getField() {
            return this.field;
        }

        public String getSourceIssue() {
            return this.sourceIssue;
        }
    }

    @XmlRootElement
    static class SourceCodeInput {
        @XmlElement
        private String sourceCode;
        @XmlElement
        private String language;
        @XmlElement
        private Map<String, String> issueKeys;
        @XmlElement
        private Integer maxResults;
        @XmlElement
        private Boolean allowChanges = false;
        @XmlElement
        private ValueDescriptor currentValue;

        private SourceCodeInput() {
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSourceCode() {
            return this.sourceCode;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public Map<String, String> getIssueKeys() {
            return this.issueKeys;
        }

        public ValueDescriptor getCurrentValue() {
            return this.currentValue;
        }

        public boolean isAllowChanges() {
            return this.allowChanges;
        }
    }
}

