/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.groovy;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SearchHelper {
    private final SearchService searchService;

    public SearchHelper(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchResults search(ApplicationUser user, String jql, Integer maxResults) throws IllegalArgumentException {
        SearchService.ParseResult parseResult = this.parseQuery(user, jql);
        if (parseResult.isValid()) {
            MessageSet messageSet = this.validateQuery(user, parseResult.getQuery());
            if (messageSet.hasAnyErrors()) {
                throw new IllegalArgumentException(messageSet.toString());
            }
            try {
                return this.search(user, parseResult.getQuery(), PagerFilter.newPageAlignedFilter((int)0, (int)maxResults));
            }
            catch (SearchException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException(parseResult.getErrors().toString());
    }

    private SearchService.ParseResult parseQuery(ApplicationUser user, String jql) {
        try {
            Method parseQuery = this.searchService.getClass().getMethod("parseQuery", ApplicationUser.class, String.class);
            return (SearchService.ParseResult)parseQuery.invoke((Object)this.searchService, user, jql);
        }
        catch (NoSuchMethodException e) {
            try {
                Method parseQuery = this.searchService.getClass().getMethod("parseQuery", User.class, String.class);
                return (SearchService.ParseResult)parseQuery.invoke((Object)this.searchService, UserCompatibilityHelper.getUserForKey(user.getKey()), jql);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private SearchResults search(ApplicationUser user, Query query, PagerFilter pager) throws SearchException {
        try {
            Method search = this.searchService.getClass().getMethod("search", ApplicationUser.class, Query.class, PagerFilter.class);
            return (SearchResults)search.invoke((Object)this.searchService, user, query, pager);
        }
        catch (NoSuchMethodException e) {
            try {
                Method search = this.searchService.getClass().getMethod("search", User.class, Query.class, PagerFilter.class);
                return (SearchResults)search.invoke((Object)this.searchService, UserCompatibilityHelper.getUserForKey(user.getKey()), query, pager);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private MessageSet validateQuery(ApplicationUser user, Query query) {
        try {
            Method validateQuery = this.searchService.getClass().getMethod("validateQuery", ApplicationUser.class, Query.class);
            return (MessageSet)validateQuery.invoke((Object)this.searchService, user, query);
        }
        catch (NoSuchMethodException e) {
            try {
                Method validateQuery = this.searchService.getClass().getMethod("validateQuery", User.class, Query.class);
                return (MessageSet)validateQuery.invoke((Object)this.searchService, UserCompatibilityHelper.getUserForKey(user.getKey()), query);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

