/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.groovy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.codehaus.groovy.runtime.InvokerHelper;

public class ScriptManager {
    private final Cache<String, Class> scriptCache;
    private final GroovyClassLoader groovyClassLoader = new GroovyClassLoader();

    public ScriptManager() {
        this.scriptCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS).build();
    }

    public Script compileGroovyExpression(final String expression) throws RuntimeException {
        String hash = DigestUtils.md5Hex((String)expression);
        try {
            Class clazz = (Class)this.scriptCache.get((Object)hash, (Callable)new Callable<Class>(){

                @Override
                public Class call() throws Exception {
                    return ScriptManager.this.groovyClassLoader.parseClass(expression);
                }
            });
            return InvokerHelper.createScript(clazz, new Binding());
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
    }
}

