/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.groovy;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.AugmentedLogger;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.groovy.SimpleTemplateEngineWithRealErrors;
import com.innovalog.groovy.rest.GroovySupportRestApi;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.util.TextUtils;
import groovy.lang.Binding;
import groovy.lang.Script;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.slf4j.LoggerFactory;

public class GroovyExpression {
    private final Binding binding;
    private final String script;
    private final AugmentedLogger logger;
    private final String language;
    private final ScriptManager scriptManager;
    private static final ThreadLocal<WorkflowUtils> workflowUtils = new ThreadLocal();
    private static final ThreadLocal<FieldValueService> fieldValueService = new ThreadLocal();
    private static final ThreadLocal<Map<MutableIssue, MyIssueChangeHolder>> issueChangeHolders = new ThreadLocal();

    static WorkflowUtils getWorkflowUtils() {
        return workflowUtils.get();
    }

    static FieldValueService getFieldValueService() {
        return fieldValueService.get();
    }

    static MyIssueChangeHolder getIssueChangeHolder(MutableIssue issue) {
        if (issueChangeHolders.get() == null) {
            return null;
        }
        MyIssueChangeHolder issueChangeHolder = issueChangeHolders.get().get(issue);
        if (issueChangeHolder == null) {
            issueChangeHolder = new MyIssueChangeHolder();
            issueChangeHolders.get().put(issue, issueChangeHolder);
        }
        return issueChangeHolder;
    }

    public Map<MutableIssue, MyIssueChangeHolder> getIssueChangeHolders() {
        return issueChangeHolders.get();
    }

    public GroovyExpression(String expression, String context, ScriptManager scriptManager) {
        this(expression, context, "groovy", scriptManager);
    }

    public GroovyExpression(String expression, String context, String language, ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
        this.binding = new Binding();
        this.script = expression;
        this.logger = new AugmentedLogger(LoggerFactory.getLogger(GroovyExpression.class), context);
        this.binding.setVariable("currentUser", ComponentAccessor.getJiraAuthenticationContext().getUser());
        this.binding.setVariable("log", this.logger);
        this.binding.setVariable("textutils", new TextUtils());
        this.binding.setVariable("TextUtils", new TextUtils());
        this.language = language == null ? "groovy" : language;
    }

    public GroovyExpression addIssueVariable(String name, Issue issue) {
        this.binding.setVariable(name, issue);
        this.binding.setVariable(name + "Object", issue);
        return this;
    }

    public GroovyExpression addVariable(String name, Object value) {
        this.binding.setVariable(name, value);
        return this;
    }

    public <T> T eval(WorkflowUtils wu, FieldValueService fvs) {
        return this.eval(wu, fvs, null);
    }

    public <T> T eval(WorkflowUtils wu, FieldValueService fvs, Map<MutableIssue, MyIssueChangeHolder> map) {
        workflowUtils.set(wu);
        fieldValueService.set(fvs);
        issueChangeHolders.set(map);
        try {
            Object result;
            Script s = this.scriptManager.compileGroovyExpression(this.script);
            s.setBinding(this.binding);
            Object object = result = s.run();
            return (T)object;
        }
        catch (Exception e) {
            this.logger.error("Groovy Script threw error: ", e);
            throw e;
        }
        finally {
            workflowUtils.set(null);
            fieldValueService.set(null);
            issueChangeHolders.set(null);
        }
    }

    public String evalTemplate(WorkflowUtils wu, FieldValueService fvs) {
        workflowUtils.set(wu);
        fieldValueService.set(fvs);
        try {
            String result;
            SimpleTemplateEngineWithRealErrors engine = new SimpleTemplateEngineWithRealErrors(this.scriptManager);
            Writable template = engine.createTemplate(this.script).make(this.binding.getVariables());
            String string = result = template.toString();
            return string;
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Groovy template threw error: ", e);
            throw new UnsupportedOperationException(e);
        }
        catch (IOException e) {
            this.logger.error("Groovy template threw error: ", e);
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            this.logger.error("Groovy Template threw error: ", e);
            throw e;
        }
        finally {
            workflowUtils.set(null);
            fieldValueService.set(null);
        }
    }

    public LocatedErrors checkSyntax() {
        LocatedErrors answer = new LocatedErrors();
        try {
            Script s = this.scriptManager.compileGroovyExpression(this.script);
            return answer;
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            if (!errorCollector.hasErrors()) {
                this.logger.error("Groovy compilation exception without error");
                return answer;
            }
            for (int i = 0; i < errorCollector.getErrorCount(); ++i) {
                SyntaxException syntaxError = errorCollector.getSyntaxError(i);
                if (syntaxError == null) continue;
                answer.add(new LocatedError(syntaxError.getMessage(), LocatedError.Severity.error, syntaxError.getLine(), syntaxError.getEndLine(), syntaxError.getStartColumn(), syntaxError.getEndColumn()));
            }
        }
        catch (CompilationFailedException e) {
            this.logger.error("Groovy compilation CompilationFailedException");
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult testScript(WorkflowUtils wu, FieldValueService fvs, Map<MutableIssue, MyIssueChangeHolder> map) {
        this.logger.setRecordLogs(true);
        TestResult answer = new TestResult();
        workflowUtils.set(wu);
        fieldValueService.set(fvs);
        issueChangeHolders.set(map);
        try {
            if (this.language.equals("groovy")) {
                Script s = this.scriptManager.compileGroovyExpression(this.script);
                s.setBinding(this.binding);
                Object result = s.run();
                if (result == null) {
                    answer.setResultString("null");
                } else {
                    answer.setResultType(result.getClass().getSimpleName());
                    answer.setResultString(result.toString());
                }
            } else if (this.language.equals("groovy-template") || this.language.equals("jql-groovy-template")) {
                SimpleTemplateEngineWithRealErrors engine = new SimpleTemplateEngineWithRealErrors(this.scriptManager);
                Writable template = engine.createTemplate(this.script).make(this.binding.getVariables());
                String result = template.toString();
                answer.setResultType("String");
                answer.setResultString(result);
            }
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            StringWriter data = new StringWriter();
            PrintWriter writer = new PrintWriter(data);
            Janitor janitor = new Janitor();
            writer.println("Compilation error(s):");
            for (Object error : errorCollector.getErrors()) {
                if (error instanceof SyntaxErrorMessage) {
                    ((SyntaxErrorMessage)error).write(writer, janitor);
                    continue;
                }
                if (!(error instanceof ExceptionMessage)) continue;
                String description = "General error : ";
                Exception cause = ((ExceptionMessage)error).getCause();
                String message = cause.getMessage();
                if (message != null) {
                    writer.println(description + message);
                } else {
                    writer.println(description + cause);
                }
                writer.println();
                if (cause.getCause() == null || cause.getCause() == cause) continue;
                writer.print("Cause by: ");
                writer.println(cause.getCause().getMessage());
            }
            answer.setErrorMessage(data.toString());
        }
        catch (Exception e) {
            answer.setErrorMessage(e.toString());
            StringWriter data = new StringWriter();
            PrintWriter writer = new PrintWriter(data);
            for (StackTraceElement ste : e.getStackTrace()) {
                if (ste.getFileName() != null && ste.getFileName().equals("Script1.groovy")) {
                    if (this.language.equals("groovy")) {
                        writer.printf("Your Groovy script(script.groovy:%d)\n", ste.getLineNumber());
                    } else {
                        writer.printf("Your Groovy template(template.groovy:%d)\n", ste.getLineNumber());
                    }
                    answer.setErrorLine(ste.getLineNumber());
                    break;
                }
                writer.println(ste.toString());
            }
            answer.setStack(data.toString());
        }
        finally {
            workflowUtils.set(null);
            fieldValueService.set(null);
            issueChangeHolders.set(null);
        }
        String logs = this.logger.getLogs();
        if (!logs.isEmpty()) {
            answer.setLogs(logs);
        }
        return answer;
    }

    public Object getVariable(String name) {
        return this.binding.getVariable(name);
    }

    @XmlRootElement
    public static class TestResult {
        @XmlElement
        private String errorMessage;
        @XmlElement
        private Integer errorLine;
        @XmlElement
        private String stack;
        @XmlElement
        private String resultType;
        @XmlElement
        private String resultString;
        @XmlElement
        private GroovySupportRestApi.IssueList issues;
        @XmlElement
        private String logs;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getStack() {
            return this.stack;
        }

        public void setStack(String stack) {
            this.stack = stack;
        }

        public String getResultType() {
            return this.resultType;
        }

        public void setResultType(String resultType) {
            this.resultType = resultType;
        }

        public String getResultString() {
            return this.resultString;
        }

        public void setResultString(String resultString) {
            this.resultString = resultString;
        }

        public void setErrorLine(Integer errorLine) {
            this.errorLine = errorLine;
        }

        public void setLogs(String logs) {
            this.logs = logs;
        }

        public void setIssues(GroovySupportRestApi.IssueList issues) {
            this.issues = issues;
        }
    }

    @XmlRootElement
    public static class LocatedError {
        @XmlElement
        private final String message;
        @XmlElement
        private final Severity severity;
        @XmlElement
        private final Integer startLine;
        @XmlElement
        private final Integer endLine;
        @XmlElement
        private final Integer startColumn;
        @XmlElement
        private final Integer endColumn;

        LocatedError(String message, Severity severity, int startLine, int endLine, int startColumn, int endColumn) {
            this.message = message;
            this.severity = severity;
            this.startLine = startLine;
            this.endLine = endLine;
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }

        LocatedError(String message, Severity severity) {
            this.message = message;
            this.severity = severity;
            this.startLine = -1;
            this.endLine = -1;
            this.startColumn = -1;
            this.endColumn = -1;
        }

        public static enum Severity {
            error,
            warning;


            public static Severity fromString(String s) {
                if (s.equalsIgnoreCase("error")) {
                    return error;
                }
                return warning;
            }
        }
    }

    @XmlRootElement
    @XmlSeeAlso(value={LocatedError.class})
    public static class LocatedErrors
    extends ArrayList<LocatedError> {
        @XmlElement(name="errors")
        public List<LocatedError> getLocatedErrors() {
            return this;
        }
    }
}

