/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.groovy;

import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class AugmentedLogger
implements Logger {
    private final Logger _delegate;
    private final String prefix;
    private StringLogger stringLogger;

    public AugmentedLogger(Logger logger, String prefix) {
        this._delegate = logger;
        if (!prefix.endsWith(" ")) {
            prefix = prefix + " ";
        }
        this.prefix = prefix;
        this.stringLogger = null;
    }

    public void setRecordLogs(boolean b) {
        this.stringLogger = b ? new StringLogger() : null;
    }

    public String getName() {
        return this.delegate().getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate().isTraceEnabled();
    }

    public void trace(String msg) {
        this.delegate().trace(this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.TRACE, msg);
        }
    }

    public void trace(String format, Object arg) {
        this.delegate().trace(this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.TRACE, ft.getMessage());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.delegate().trace(this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.TRACE, ft.getMessage());
        }
    }

    public void trace(String format, Object ... arguments) {
        this.delegate().trace(this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.TRACE, ft.getMessage());
        }
    }

    public void trace(String msg, Throwable t) {
        this.delegate().trace(this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.TRACE, msg);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate().isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.delegate().trace(marker, this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.TRACE, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        this.delegate().trace(marker, this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.TRACE, ft.getMessage());
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate().trace(marker, this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.TRACE, ft.getMessage());
        }
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.delegate().trace(marker, this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.TRACE, ft.getMessage());
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.delegate().trace(marker, this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.TRACE, msg);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate().isDebugEnabled();
    }

    public void debug(String msg) {
        this.delegate().debug(this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.DEBUG, msg);
        }
    }

    public void debug(String format, Object arg) {
        this.delegate().debug(this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.DEBUG, ft.getMessage());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.delegate().debug(this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.DEBUG, ft.getMessage());
        }
    }

    public void debug(String format, Object ... arguments) {
        this.delegate().debug(this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.DEBUG, ft.getMessage());
        }
    }

    public void debug(String msg, Throwable t) {
        this.delegate().debug(this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.DEBUG, msg);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate().isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.delegate().debug(marker, this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.DEBUG, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        this.delegate().debug(marker, this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.DEBUG, ft.getMessage());
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate().debug(marker, this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.DEBUG, ft.getMessage());
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.delegate().debug(marker, this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.DEBUG, ft.getMessage());
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.delegate().debug(marker, this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.DEBUG, msg);
        }
    }

    public boolean isInfoEnabled() {
        return this.delegate().isInfoEnabled();
    }

    public void info(String msg) {
        this.delegate().info(this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.INFO, msg);
        }
    }

    public void info(String format, Object arg) {
        this.delegate().info(this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.INFO, ft.getMessage());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        this.delegate().info(this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.INFO, ft.getMessage());
        }
    }

    public void info(String format, Object ... arguments) {
        this.delegate().info(this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.INFO, ft.getMessage());
        }
    }

    public void info(String msg, Throwable t) {
        this.delegate().info(this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.INFO, msg);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate().isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.delegate().info(marker, this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.INFO, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        this.delegate().info(marker, this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.INFO, ft.getMessage());
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate().info(marker, this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.INFO, ft.getMessage());
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.delegate().info(marker, this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.INFO, ft.getMessage());
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.delegate().info(marker, this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.INFO, msg);
        }
    }

    public boolean isWarnEnabled() {
        return this.delegate().isWarnEnabled();
    }

    public void warn(String msg) {
        this.delegate().warn(this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.WARN, msg);
        }
    }

    public void warn(String format, Object arg) {
        this.delegate().warn(this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.WARN, ft.getMessage());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.delegate().warn(this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.WARN, ft.getMessage());
        }
    }

    public void warn(String format, Object ... arguments) {
        this.delegate().warn(this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.WARN, ft.getMessage());
        }
    }

    public void warn(String msg, Throwable t) {
        this.delegate().warn(this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.WARN, msg);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate().isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.delegate().warn(marker, this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.WARN, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        this.delegate().warn(marker, this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.WARN, ft.getMessage());
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate().warn(marker, this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.WARN, ft.getMessage());
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.delegate().warn(marker, this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.WARN, ft.getMessage());
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.delegate().warn(marker, this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.WARN, msg);
        }
    }

    public boolean isErrorEnabled() {
        return this.delegate().isErrorEnabled();
    }

    public void error(String msg) {
        this.delegate().error(this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.ERROR, msg);
        }
    }

    public void error(String format, Object arg) {
        this.delegate().error(this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.ERROR, ft.getMessage());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        this.delegate().error(this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.ERROR, ft.getMessage());
        }
    }

    public void error(String format, Object ... arguments) {
        this.delegate().error(this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.ERROR, ft.getMessage());
        }
    }

    public void error(String msg, Throwable t) {
        this.delegate().error(this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.ERROR, msg);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate().isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.delegate().error(marker, this.prefix + msg);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.ERROR, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        this.delegate().error(marker, this.prefix + format, arg);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.stringLogger.log(Level.ERROR, ft.getMessage());
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate().error(marker, this.prefix + format, arg1, arg2);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.stringLogger.log(Level.ERROR, ft.getMessage());
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.delegate().error(marker, this.prefix + format, arguments);
        if (this.stringLogger != null) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.stringLogger.log(Level.ERROR, ft.getMessage());
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.delegate().error(marker, this.prefix + msg, t);
        if (this.stringLogger != null) {
            this.stringLogger.log(Level.ERROR, msg);
        }
    }

    public String getLogs() {
        if (this.stringLogger == null) {
            return "";
        }
        return this.stringLogger.getLogs();
    }

    Logger delegate() {
        return this._delegate;
    }

    private class StringLogger {
        StringBuilder sb = new StringBuilder();

        private StringLogger() {
        }

        public void log(Level level, String msg) {
            this.sb.append(String.format("%-5s: ", level.toString()) + msg + "\n");
        }

        public String getLogs() {
            return this.sb.toString();
        }
    }
}

