/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.admin;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PickerApi {
    private final GlobalPermissionManager globalPermissionManager;
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final ProjectRoleManager projectRoleManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public PickerApi(GlobalPermissionManager globalPermissionManager, FieldCollectionsUtils fieldCollectionsUtils, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.globalPermissionManager = globalPermissionManager;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.projectRoleManager = projectRoleManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Path(value="role/picker")
    public Response rolePicker(@QueryParam(value="query") String query) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<GenericElem> roles = new ArrayList<GenericElem>();
        Pattern regExp = StringUtils.isEmpty(query) ? Pattern.compile(".*") : Pattern.compile("(" + Pattern.quote(query) + ")", 2);
        for (ProjectRole role : this.projectRoleManager.getProjectRoles()) {
            Matcher matcher = regExp.matcher(role.getName());
            if (!matcher.find()) continue;
            String html = StringUtils.isEmpty(query) ? role.getName() : matcher.replaceAll("<b>$1</b>");
            roles.add(new GenericElem(role.getName(), null, html, role.getId()));
        }
        return Response.ok(roles).build();
    }

    @GET
    @Path(value="permission/picker")
    public Response permissionPicker(@QueryParam(value="query") String query) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<GenericElem> permissions = new ArrayList<GenericElem>();
        Pattern regExp = StringUtils.isEmpty(query) ? Pattern.compile(".*") : Pattern.compile("(" + Pattern.quote(query) + ")", 2);
        for (ProjectPermission permission : this.permissionManager.getAllProjectPermissions()) {
            String permName = this.jiraAuthenticationContext.getI18nHelper().getText(permission.getNameI18nKey());
            Matcher matcher = regExp.matcher(permName);
            if (!matcher.find()) continue;
            String html = StringUtils.isEmpty(query) ? permName : matcher.replaceAll("<b>$1</b>");
            permissions.add(new GenericElem(permName, permission.getKey(), html, null));
        }
        return Response.ok(permissions).build();
    }

    @GET
    @Path(value="field/picker/{type}")
    public Response fieldPicker(@PathParam(value="type") String type, @QueryParam(value="query") String query) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<GenericElem> fields = new ArrayList<GenericElem>();
        Pattern regExp = StringUtils.isEmpty(query) ? Pattern.compile(".*") : Pattern.compile("(" + Pattern.quote(query) + ")", 2);
        try {
            Method method = this.fieldCollectionsUtils.getClass().getMethod("get" + type + "Fields", new Class[0]);
            for (Field field : (Collection)method.invoke((Object)this.fieldCollectionsUtils, new Object[0])) {
                Matcher matcher = regExp.matcher(field.getName());
                if (!matcher.find()) continue;
                String html = StringUtils.isEmpty(query) ? field.getName() : matcher.replaceAll("<b>$1</b>");
                fields.add(new GenericElem(field.getName(), field.getId(), html, null));
            }
            return Response.ok(fields).build();
        }
        catch (NoSuchMethodException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvocationTargetException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @XmlRootElement
    public static class GenericElem {
        @XmlElement
        private String name;
        @XmlElement
        private String key;
        @XmlElement
        private String html;
        @XmlElement
        private Long id;

        public GenericElem(String name, String key, String html, Long id) {
            this.name = name;
            this.id = id;
            this.key = key;
            this.html = html;
        }
    }
}

