/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.util;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.ImportIdLinkCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.ReadOnlyCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Sets;
import com.googlecode.jsu.helpers.NameComparatorEx;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCollectionsUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldCollectionsUtils.class);
    private static final Collection<String> TIME_TRACKING_FIELDS = Arrays.asList("timeestimate", "timeoriginalestimate", "timespent", "timetracking", "worklog");
    private final I18nHelper.BeanFactory i18nHelper;
    private final ApplicationProperties applicationProperties;
    private final DateTimeFormatter dateTimeFormatter;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final CustomFieldManager customFieldManager;
    private final FieldVisibilityManager fieldVisibilityManager;

    public FieldCollectionsUtils(I18nHelper.BeanFactory i18nHelper, ApplicationProperties applicationProperties, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, CustomFieldManager customFieldManager, FieldVisibilityManager fieldVisibilityManager) {
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.dateTimeFormatter = (DateTimeFormatter)ComponentManager.getComponent(DateTimeFormatter.class);
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.customFieldManager = customFieldManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public List<Field> getAllFields() {
        TreeSet<Field> allFieldsSet = new TreeSet<Field>(this.getComparator());
        allFieldsSet.addAll(this.fieldManager.getOrderableFields());
        try {
            allFieldsSet.addAll(this.fieldManager.getAllAvailableNavigableFields());
        }
        catch (FieldException e) {
            log.error("Unable to load navigable fields", (Throwable)e);
        }
        return new ArrayList<Field>(allFieldsSet);
    }

    public List<Field> getAllEditableFields() {
        TreeSet<Field> allFields = new TreeSet<Field>(this.getComparator());
        try {
            Set fields = this.fieldManager.getAllAvailableNavigableFields();
            for (Field f : fields) {
                allFields.add(f);
            }
        }
        catch (FieldException e) {
            log.error("Unable to load navigable fields", (Throwable)e);
        }
        return new ArrayList<Field>(allFields);
    }

    public List<Field> getAllMultiEditableFields() {
        TreeSet<Field> allFields = new TreeSet<Field>(this.getComparator());
        try {
            Set fields = this.fieldManager.getAllAvailableNavigableFields();
            allFields.addAll(this.getMultiSystemFields());
            for (Field f : fields) {
                if (!this.fieldManager.isCustomField(f) || !(this.customFieldManager.getCustomFieldObject(f.getId()).getCustomFieldType() instanceof AbstractMultiCFType) && !(this.customFieldManager.getCustomFieldObject(f.getId()).getCustomFieldType() instanceof LabelsCFType)) continue;
                allFields.add(f);
            }
        }
        catch (FieldException e) {
            log.error("Unable to load navigable fields", (Throwable)e);
        }
        return new ArrayList<Field>(allFields);
    }

    public List<Field> sortFields(List<Field> allFields) {
        Collections.sort(allFields, this.getComparator());
        return allFields;
    }

    public List<Field> getAllDateFields() {
        ArrayList<Field> allDateFields = new ArrayList<Field>();
        List fields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField cfDate : fields) {
            CustomFieldType customFieldType = cfDate.getCustomFieldType();
            if (!(customFieldType instanceof DateCFType) && !(customFieldType instanceof DateTimeCFType)) continue;
            allDateFields.add((Field)cfDate);
        }
        allDateFields.addAll(Arrays.asList(this.fieldManager.getField("duedate"), this.fieldManager.getField("created"), this.fieldManager.getField("updated"), this.fieldManager.getField("resolutiondate")));
        return this.sortFields(allDateFields);
    }

    public boolean isFieldOnScreen(Issue issue, Field field, FieldScreen fieldScreen) {
        CustomFieldType type;
        if ("comment".equals(field.getId())) {
            return true;
        }
        if (this.fieldManager.isCustomField(field) && ((type = ((CustomField)field).getCustomFieldType()) instanceof ReadOnlyCFType || type instanceof ImportIdLinkCFType)) {
            return false;
        }
        boolean retVal = false;
        Iterator itTabs = fieldScreen.getTabs().iterator();
        while (itTabs.hasNext() && !retVal) {
            FieldScreenTab tab = (FieldScreenTab)itTabs.next();
            Iterator itFields = tab.getFieldScreenLayoutItems().iterator();
            while (itFields.hasNext() && !retVal) {
                FieldScreenLayoutItem fieldScreenLayoutItem = (FieldScreenLayoutItem)itFields.next();
                if ((!field.getId().equals(fieldScreenLayoutItem.getFieldId()) || !this.isIssueHasField(issue, field)) && (!TIME_TRACKING_FIELDS.contains(field.getId()) || !TIME_TRACKING_FIELDS.contains(fieldScreenLayoutItem.getFieldId()))) continue;
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean cannotSetValidationMessageToField(Field field) {
        return TIME_TRACKING_FIELDS.contains(field.getId());
    }

    public boolean isIssueHasField(Issue issue, Field field) {
        String fieldId = field.getId();
        boolean isHidden = false;
        isHidden = TIME_TRACKING_FIELDS.contains(fieldId) ? !this.fieldManager.isTimeTrackingOn() : this.fieldVisibilityManager.isFieldHidden(field.getId(), issue);
        if (isHidden) {
            return false;
        }
        if (this.fieldManager.isCustomField(field)) {
            CustomField customField = (CustomField)field;
            FieldConfig config = customField.getRelevantConfig(issue);
            return config != null;
        }
        return true;
    }

    public FieldLayoutItem getFieldLayoutItem(Issue issue, Field field) {
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId());
        if (layout.getId() == null) {
            layout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
        }
        return layout.getFieldLayoutItem(field.getId());
    }

    public boolean isFieldRequired(Issue issue, Field field) {
        boolean retVal = false;
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(issue, field);
        if (fieldLayoutItem != null) {
            retVal = fieldLayoutItem.isRequired();
        }
        return retVal;
    }

    public List<Field> getCopyFromFields() {
        List<Field> allFields = this.getAllFields();
        allFields.removeAll(this.getNonCopyFromFields());
        return allFields;
    }

    private List<Field> getNonCopyFromFields() {
        return this.asFields("attachment", "comment", "issuelinks", "subtasks", "thumbnail", "timetracking");
    }

    private List<Field> getMultiSystemFields() {
        return this.asFields("versions", "components", "fixVersions", "issuelinks", "subtasks", "labels", "votes", "watches");
    }

    public List<Field> getCopyToFields() {
        List<Field> allFields = this.getAllFields();
        allFields.removeAll(this.getNonCopyToFields());
        this.removeCustomNonCopyToFields(allFields);
        return allFields;
    }

    public List<Field> getCopyToMultiFields() {
        List<Field> allFields = this.getAllMultiEditableFields();
        allFields.removeAll(this.getNonCopyToFields());
        this.removeCustomNonCopyToFields(allFields);
        return allFields;
    }

    private void removeCustomNonCopyToFields(List<Field> allFields) {
        Iterator<Field> iterator = allFields.iterator();
        while (iterator.hasNext()) {
            CustomField cf;
            String cfTypeKey;
            Field field = iterator.next();
            if (!(field instanceof CustomField) || !(cfTypeKey = (cf = (CustomField)field).getCustomFieldType().getKey()).equals("com.atlassian.servicedesk:sd-request-feedback") && !cfTypeKey.equals("com.atlassian.servicedesk:sd-request-feedback-date") && !cfTypeKey.equals("com.atlassian.servicedesk:sd-sla-field") && !cfTypeKey.equals("com.pyxis.greenhopper.jira:gh-lexo-rank")) continue;
            iterator.remove();
        }
    }

    private List<Field> getNonCopyToFields() {
        return this.asFields("attachment", "comment", "created", "timetracking", "aggregatetimeoriginalestimate", "aggregatetimeestimate", "aggregateprogress", "aggregatetimespent", "issuekey", "issuelinks", "project", "status", "subtasks", "thumbnail", "updated", "workratio", "resolutiondate", "progress", "worklog", "lastViewed", "creator");
    }

    public Set<String> getNonIssueInputParamFields() {
        return Sets.newHashSet((Object[])new String[]{"watches", "votes"});
    }

    public List<Field> getRequirableFields() {
        List<Field> allFields = this.getAllFields();
        allFields.removeAll(this.getNonRequirableFields());
        return allFields;
    }

    private List<Field> getNonRequirableFields() {
        return this.asFields("created", "timetracking", "progress", "aggregatetimeoriginalestimate", "aggregateprogress", "issuekey", "issuetype", "project", "status", "thumbnail", "updated", "votes", "workratio", "worklog", "aggregatetimeestimate", "aggregatetimespent");
    }

    public List<Field> getValueFieldConditionFields() {
        List<Field> allFields = this.getAllFields();
        allFields.removeAll(this.getNonValueFieldConditionFields());
        allFields.removeAll(this.getAllDateFields());
        return allFields;
    }

    private List<Field> getNonValueFieldConditionFields() {
        return this.asFields("attachment", "comment", "created", "issuekey", "issuelinks", "subtasks", "thumbnail", "timetracking", "updated", "workratio");
    }

    public void clearCalendarTimePart(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public String getNiceDate(Timestamp tsDate) {
        Date timePerformed = new Date(tsDate.getTime());
        return this.dateTimeFormatter.format(timePerformed);
    }

    private Comparator<Field> getComparator() {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        return new NameComparatorEx(i18n);
    }

    private List<Field> asFields(String ... names) {
        ArrayList<Field> result = new ArrayList<Field>(names.length);
        for (String name : names) {
            result.add(this.fieldManager.getField(name));
        }
        return result;
    }
}

