/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.annotation;

import com.googlecode.jsu.annotation.AbstractVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFieldProcessor
extends AbstractVisitor {
    private final Logger log = LoggerFactory.getLogger(MapFieldProcessor.class);
    private final Class<? extends Annotation> annotation;
    private final Map<String, Object> values;

    public MapFieldProcessor(Class<? extends Annotation> annotation, Map<String, Object> values) {
        this.annotation = annotation;
        this.values = values;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    @Override
    public void visitField(Object source, Field field, Annotation sourceAnnon) {
        String fieldName = this.getAnnotationValue(sourceAnnon);
        if (fieldName == null || "".equals(fieldName)) {
            fieldName = field.getName();
        }
        try {
            boolean access = field.isAccessible();
            field.setAccessible(true);
            field.set(source, this.values.get(fieldName));
            field.setAccessible(access);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Unable to set class field - " + fieldName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("Unable to set class field - " + fieldName, (Throwable)e);
        }
    }

    protected String getAnnotationValue(Annotation annotation) {
        String result = null;
        try {
            Method valueMethod = annotation.getClass().getDeclaredMethod("value", new Class[0]);
            result = (String)valueMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result;
    }
}

