/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.storage.lib.ManagerAccessor;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ThirdPartyPluginLicenseStorageManagerImpl
implements ApplicationContextAware,
ThirdPartyPluginLicenseStorageManager {
    private ManagerAccessor managerAccessor;
    private final ApplicationProperties applicationProperties;

    public ThirdPartyPluginLicenseStorageManagerImpl(ApplicationProperties applicationProperties) {
        this(applicationProperties, null);
    }

    public ThirdPartyPluginLicenseStorageManagerImpl(ApplicationProperties applicationProperties, ManagerAccessor managerAccessor) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.managerAccessor = managerAccessor;
    }

    @Override
    public Option<PluginLicense> getLicense() throws PluginLicenseStoragePluginUnresolvedException {
        return this.getLicenseManager().getLicense();
    }

    @Override
    public Option<String> getRawLicense() throws PluginLicenseStoragePluginUnresolvedException {
        return this.getLicenseManager().getLicense().map((Function)new Function<PluginLicense, String>(){

            public String apply(PluginLicense license) {
                return license.getRawLicense();
            }
        });
    }

    @Override
    public Option<String> setRawLicense(String rawLicense) throws PluginLicenseStoragePluginUnresolvedException {
        throw new UnsupportedOperationException("Cannot set license manually when UPM is license-aware. Please use UPM's licensing UI.");
    }

    @Override
    public Option<String> removeRawLicense() throws PluginLicenseStoragePluginUnresolvedException {
        throw new UnsupportedOperationException("Cannot remove license manually when UPM is license-aware. Please use UPM's licensing UI.");
    }

    @Override
    public Option<PluginLicense> validateLicense(String rawLicense) throws PluginLicenseStoragePluginUnresolvedException {
        throw new UnsupportedOperationException("Cannot validate license manually when UPM is license-aware. Please use UPM's licensing UI.");
    }

    @Override
    public Option<Integer> getCurrentUserCountInLicenseRole() throws PluginLicenseStoragePluginUnresolvedException {
        return this.getLicenseManager().getCurrentUserCountInLicenseRole();
    }

    @Override
    public boolean isUpmLicensingAware() {
        return true;
    }

    @Override
    public String getPluginKey() throws PluginLicenseStoragePluginUnresolvedException {
        return this.getLicenseManager().getPluginKey();
    }

    @Override
    public URI getPluginManagementUri() throws PluginLicenseStoragePluginUnresolvedException {
        return URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/upm?fragment=manage/" + this.getPluginKey()).normalize();
    }

    @Override
    public boolean isOnDemand() {
        return false;
    }

    private PluginLicenseManager getLicenseManager() {
        return this.managerAccessor.getLicenseManager();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.managerAccessor = new ManagerAccessor(applicationContext);
    }
}

