/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.impl.CollectionUtils;
import com.atlassian.upm.license.storage.lib.AtlassianMarketplaceUriFactory;
import com.atlassian.upm.license.storage.lib.ManagerAccessor;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.atlassian.upm.license.storage.lib.UrlEncoder;
import com.atlassian.upm.license.storage.lib.VersionChecker;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AtlassianMarketplaceUriFactoryImpl
implements AtlassianMarketplaceUriFactory,
ApplicationContextAware {
    private final ThirdPartyPluginLicenseStorageManager licenseManager;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private ManagerAccessor managerAccessor;

    public AtlassianMarketplaceUriFactoryImpl(ThirdPartyPluginLicenseStorageManager licenseManager, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor) {
        this(licenseManager, applicationProperties, pluginAccessor, null);
    }

    AtlassianMarketplaceUriFactoryImpl(ThirdPartyPluginLicenseStorageManager licenseManager, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, ManagerAccessor managerAccessor) {
        this.licenseManager = (ThirdPartyPluginLicenseStorageManager)Preconditions.checkNotNull((Object)licenseManager, (Object)"licenseManager");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.managerAccessor = managerAccessor;
    }

    @Override
    public URI getReviewPluginUri(int stars, Option<String> review) {
        this.validateReviewOrWatchAccess();
        return this.getUpmRestUri("/available/%s/review", Option.some((Object)Pair.pair((Object)"stars", (Object)String.valueOf(stars))), this.getReview(review));
    }

    @Override
    public URI getWatchPluginUri() {
        this.validateReviewOrWatchAccess();
        return this.getUpmRestUri("/available/%s/watch", new Option[0]);
    }

    @Override
    public boolean canReviewPlugin() {
        return this.canReviewOrWatch();
    }

    @Override
    public boolean canWatchPlugin() {
        return this.canReviewOrWatch();
    }

    @Override
    public URI getBuyPluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        throw this.macUriMethodsUnsupportedException();
    }

    @Override
    public URI getTryPluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        throw this.macUriMethodsUnsupportedException();
    }

    @Override
    public URI getRenewPluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        throw this.macUriMethodsUnsupportedException();
    }

    @Override
    public URI getUpgradePluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        throw this.macUriMethodsUnsupportedException();
    }

    private UnsupportedOperationException macUriMethodsUnsupportedException() {
        return new UnsupportedOperationException("Cannot build MyAtlassian URI when UPM is licensing-aware: required data is unavailable. Please use UPM's licensingUI instead.");
    }

    @Override
    public boolean isPluginBuyable() throws PluginLicenseStoragePluginUnresolvedException {
        return false;
    }

    @Override
    public boolean isPluginTryable() throws PluginLicenseStoragePluginUnresolvedException {
        return false;
    }

    @Override
    public boolean isPluginRenewable() throws PluginLicenseStoragePluginUnresolvedException {
        return false;
    }

    @Override
    public boolean isPluginUpgradable() throws PluginLicenseStoragePluginUnresolvedException {
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.managerAccessor = new ManagerAccessor(applicationContext);
    }

    private String getPluginKey() throws PluginLicenseStoragePluginUnresolvedException {
        return this.licenseManager.getPluginKey();
    }

    private String buildRequestParamString(Option<Pair<String, String>> ... params) {
        Iterable nonNoneParams = Options.catOptions(CollectionUtils.immutableListOf(params));
        Iterable paramStrings = Iterables.transform((Iterable)nonNoneParams, (Function)new Function<Pair<String, String>, String>(){

            public String apply(Pair<String, String> param) {
                return (String)param.first() + "=" + (String)param.second();
            }
        });
        String joined = Joiner.on((String)"&").join(paramStrings);
        if (StringUtils.isNotBlank((String)joined)) {
            joined = "?" + joined;
        }
        return joined;
    }

    private URI getUpmRestUri(String path, Option<Pair<String, String>> ... params) {
        String pluginKey = UrlEncoder.encode(this.managerAccessor.getLicenseManager().getPluginKey());
        return URI.create(this.applicationProperties.getBaseUrl() + "/rest/plugins/1.0" + String.format(path, pluginKey) + this.buildRequestParamString(params));
    }

    private Option<Pair<String, String>> getReview(Option<String> review) {
        for (String r : review) {
            if (StringUtils.isBlank((String)r)) continue;
            return Option.some((Object)Pair.pair((Object)"review", (Object)UrlEncoder.encode(r)));
        }
        return Option.none();
    }

    private boolean canReviewOrWatch() {
        return VersionChecker.isUpm28OrLaterInstalled(this.pluginAccessor) && this.managerAccessor.getUpmHostLicenseInformation().hostSen().isDefined();
    }

    private void validateReviewOrWatchAccess() {
        if (!VersionChecker.isUpm28OrLaterInstalled(this.pluginAccessor)) {
            throw new IllegalStateException("UPM 2.8+ is required");
        }
        if (!this.managerAccessor.getUpmHostLicenseInformation().hostSen().isDefined()) {
            throw new IllegalStateException("Application should have a Support Entitlement Number (SEN)");
        }
    }
}

