/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class LicensedAttributes {
    public static final Integer NEARLY_EXPIRED_DAYS = 7;
    public static final Integer RECENTLY_EXPIRED_DAYS = 7;
    private static final ImmutableSet<String> RENEWABLE_TYPES = ImmutableSet.of((Object)LicenseType.ACADEMIC.name(), (Object)LicenseType.COMMERCIAL.name(), (Object)LicenseType.COMMUNITY.name(), (Object)LicenseType.OPEN_SOURCE.name(), (Object)LicenseType.STARTER.name());

    public static boolean isProductBuyable(Option<LicenseAttributes> license) {
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            LicenseAttributes registeredLicense = (LicenseAttributes)iterator.next();
            return registeredLicense.evaluation || LicensedAttributes.isErrorEqual((Option<String>)registeredLicense.licenseError, LicenseError.TYPE_MISMATCH.name());
        }
        return true;
    }

    public static boolean isProductTryable(Option<LicenseAttributes> license) {
        return !license.isDefined();
    }

    public static boolean isProductRenewable(Option<LicenseAttributes> license, Option<Integer> currentRoleCount) {
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            LicenseAttributes registeredLicense = (LicenseAttributes)iterator.next();
            boolean hasAppropriateType = RENEWABLE_TYPES.contains((Object)registeredLicense.licenseType);
            return LicensedAttributes.isProductRenewableInternal(license, currentRoleCount) && hasAppropriateType;
        }
        return false;
    }

    public static boolean isProductRenewableRequiringContact(Option<LicenseAttributes> license, Option<Integer> currentRoleCount) {
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            LicenseAttributes registeredLicense = (LicenseAttributes)iterator.next();
            boolean hasAppropriateType = RENEWABLE_TYPES.contains((Object)registeredLicense.licenseType);
            return LicensedAttributes.isProductRenewableInternal(license, currentRoleCount) && !hasAppropriateType;
        }
        return false;
    }

    private static boolean isProductRenewableInternal(Option<LicenseAttributes> license, Option<Integer> currentRoleCount) {
        if (LicensedAttributes.isProductUpgradable(license, currentRoleCount)) {
            return false;
        }
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            LicenseAttributes registeredLicense = (LicenseAttributes)iterator.next();
            boolean nearlyExpired = LicensedAttributes.isNearlyExpired().apply((Object)registeredLicense);
            boolean nearlyMaintenanceExpired = LicensedAttributes.isNearlyMaintenanceExpired().apply((Object)registeredLicense);
            boolean maintenanceExpired = registeredLicense.isMaintenanceExpired();
            boolean hasAppropriateError = LicensedAttributes.isErrorIn((Option<String>)registeredLicense.licenseError, (Iterable<String>)ImmutableSet.of((Object)LicenseError.EXPIRED.name(), (Object)LicenseError.VERSION_MISMATCH.name()));
            boolean evaluation = registeredLicense.evaluation;
            boolean active = registeredLicense.active;
            return active && (nearlyExpired || nearlyMaintenanceExpired || maintenanceExpired || hasAppropriateError) && !evaluation;
        }
        return false;
    }

    public static boolean isProductUpgradable(Option<LicenseAttributes> license, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductUpgradeRequired(license) || LicensedAttributes.isProductUpgradeNearlyRequired(license, currentRoleCount);
    }

    public static boolean isProductUpgradeNearlyRequired(Option<LicenseAttributes> license, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isRoleNearlyExceeded(license, currentRoleCount);
    }

    public static boolean isProductUpgradeRequired(Option<LicenseAttributes> license) {
        if (LicensedAttributes.isProductBuyable(license)) {
            return false;
        }
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            LicenseAttributes registeredLicense = (LicenseAttributes)iterator.next();
            return LicensedAttributes.isErrorIn((Option<String>)registeredLicense.licenseError, (Iterable<String>)ImmutableList.of((Object)LicenseError.USER_MISMATCH.name(), (Object)LicenseError.EDITION_MISMATCH.name(), (Object)LicenseError.ROLE_EXCEEDED.name()));
        }
        return false;
    }

    public static boolean isRoleNearlyExceeded(Option<LicenseAttributes> license, Option<Integer> currentRoleCount) {
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            LicenseAttributes registeredLicense = (LicenseAttributes)iterator.next();
            return LicensedAttributes.isRoleNearlyExceeded(currentRoleCount).apply((Object)registeredLicense);
        }
        return false;
    }

    public static Predicate<LicenseAttributes> isRoleNearlyExceeded(final Option<Integer> currentRoleCount) {
        return new Predicate<LicenseAttributes>(){

            public boolean apply(LicenseAttributes license) {
                Iterator iterator = currentRoleCount.iterator();
                while (iterator.hasNext()) {
                    int currRoleCount = (Integer)iterator.next();
                    Iterator iterator2 = license.edition.iterator();
                    if (!iterator2.hasNext()) continue;
                    int maxRoleCount = (Integer)iterator2.next();
                    if (currRoleCount > maxRoleCount) {
                        return false;
                    }
                    if (maxRoleCount > 5) {
                        return (double)currRoleCount >= (double)maxRoleCount * 0.8;
                    }
                    return currRoleCount >= maxRoleCount - 1;
                }
                return false;
            }
        };
    }

    public static Predicate<LicenseAttributes> isNearlyExpired() {
        return new Predicate<LicenseAttributes>(){

            public boolean apply(LicenseAttributes license) {
                Iterator iterator = license.expiryDate.iterator();
                if (iterator.hasNext()) {
                    DateTime expiryDate = (DateTime)iterator.next();
                    return new Interval((ReadableInstant)expiryDate.minusDays(NEARLY_EXPIRED_DAYS.intValue()), (ReadableInstant)expiryDate).contains((ReadableInstant)new DateTime());
                }
                return false;
            }
        };
    }

    public static Predicate<LicenseAttributes> isNearlyMaintenanceExpired() {
        return new Predicate<LicenseAttributes>(){

            public boolean apply(LicenseAttributes license) {
                Iterator iterator = license.maintenanceExpiryDate.iterator();
                if (iterator.hasNext()) {
                    DateTime maintenanceExpiryDate = (DateTime)iterator.next();
                    return new Interval((ReadableInstant)maintenanceExpiryDate.minusDays(NEARLY_EXPIRED_DAYS.intValue()), (ReadableInstant)maintenanceExpiryDate).contains((ReadableInstant)new DateTime());
                }
                return false;
            }
        };
    }

    private static boolean isErrorEqual(Option<String> possibleError, String equalTo) {
        Iterator iterator = possibleError.iterator();
        if (iterator.hasNext()) {
            String error = (String)iterator.next();
            return equalTo.equalsIgnoreCase(error);
        }
        return false;
    }

    private static boolean isErrorIn(Option<String> possibleError, Iterable<String> errors) {
        Iterable lowercaseErrorNames = Iterables.transform(errors, (Function)new Function<String, String>(){

            public String apply(String e) {
                return e.toLowerCase();
            }
        });
        Iterator iterator = possibleError.iterator();
        if (iterator.hasNext()) {
            String error = (String)iterator.next();
            return Iterables.contains((Iterable)lowercaseErrorNames, (Object)error.toLowerCase());
        }
        return false;
    }

    public static class LicenseAttributes {
        private final boolean active;
        private final boolean evaluation;
        private final Option<DateTime> expiryDate;
        private final Option<DateTime> maintenanceExpiryDate;
        private final Option<String> licenseError;
        private final Option<Integer> edition;
        private final String licenseType;

        private LicenseAttributes(Builder builder) {
            this.active = (Boolean)Preconditions.checkNotNull((Object)builder.active, (Object)"active");
            this.evaluation = (Boolean)Preconditions.checkNotNull((Object)builder.evaluation, (Object)"evaluation");
            this.expiryDate = (Option)Preconditions.checkNotNull((Object)builder.expiryDate, (Object)"expiryDate");
            this.maintenanceExpiryDate = (Option)Preconditions.checkNotNull((Object)builder.maintenanceExpiryDate, (Object)"maintenanceExpiryDate");
            this.licenseError = (Option)Preconditions.checkNotNull((Object)builder.licenseError, (Object)"licenseError");
            this.edition = (Option)Preconditions.checkNotNull((Object)builder.edition, (Object)"edition");
            this.licenseType = (String)Preconditions.checkNotNull((Object)builder.licenseType, (Object)"licenseType");
        }

        public boolean isMaintenanceExpired() {
            Iterator iterator = this.maintenanceExpiryDate.iterator();
            if (iterator.hasNext()) {
                DateTime maintenanceExpiry = (DateTime)iterator.next();
                return maintenanceExpiry.isBeforeNow();
            }
            return false;
        }

        public static Option<LicenseAttributes> from(Option<PluginLicense> pluginLicense) {
            Iterator iterator = pluginLicense.iterator();
            if (iterator.hasNext()) {
                PluginLicense l = (PluginLicense)iterator.next();
                return Option.some((Object)LicenseAttributes.from(l));
            }
            return Option.none();
        }

        public static LicenseAttributes from(PluginLicense pluginLicense) {
            return LicenseAttributes.builder().active(pluginLicense.isActive()).evaluation(pluginLicense.isEvaluation()).expiryDate((Option<DateTime>)pluginLicense.getExpiryDate()).maintenanceExpiryDate((Option<DateTime>)pluginLicense.getMaintenanceExpiryDate()).licenseError((Option<String>)pluginLicense.getError().map((Function)new Function<LicenseError, String>(){

                public String apply(LicenseError e) {
                    return e.name();
                }
            })).edition((Option<Integer>)pluginLicense.getEdition()).licenseType(pluginLicense.getLicenseType().name()).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean active;
            private Boolean evaluation;
            private Option<DateTime> expiryDate;
            private Option<DateTime> maintenanceExpiryDate;
            private Option<String> licenseError;
            private Option<Integer> edition;
            private String licenseType;

            public Builder active(boolean active) {
                this.active = active;
                return this;
            }

            public Builder evaluation(boolean evaluation) {
                this.evaluation = evaluation;
                return this;
            }

            public Builder licenseError(Option<String> licenseError) {
                this.licenseError = licenseError;
                return this;
            }

            public Builder edition(Option<Integer> edition) {
                this.edition = edition;
                return this;
            }

            public Builder expiryDate(Option<DateTime> expiryDate) {
                this.expiryDate = expiryDate;
                return this;
            }

            public Builder maintenanceExpiryDate(Option<DateTime> maintenanceExpiryDate) {
                this.maintenanceExpiryDate = maintenanceExpiryDate;
                return this;
            }

            public Builder licenseType(String licenseType) {
                this.licenseType = licenseType;
                return this;
            }

            public LicenseAttributes build() {
                return new LicenseAttributes(this);
            }
        }
    }
}

