/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.sal.usercompatibility.UserKey;
import com.atlassian.util.concurrent.Supplier;

public abstract class Locks {
    public static ClusterLock getLock(ClusterLockService lockService, Class lockOwner) {
        return lockService.getLockForName(lockOwner.getName());
    }

    public static ClusterLock getLock(ClusterLockService lockService, Class lockOwner, String lockId) {
        return lockService.getLockForName(lockOwner.getName() + ":" + lockId);
    }

    public static ClusterLock getLock(ClusterLockService lockService, Class lockOwner, UserKey user) {
        return Locks.getLock(lockService, lockOwner, user.getStringValue());
    }

    public static <T> T writeWithLock(ClusterLock lock, Supplier<T> task) {
        return Locks.runWithLock(lock, task);
    }

    public static void writeWithLock(ClusterLock lock, final Runnable task) {
        Locks.runWithLock(lock, new Supplier<Void>(){

            public Void get() {
                task.run();
                return null;
            }
        });
    }

    public static <T> T readWithLock(ClusterLock lock, Supplier<T> task) {
        return Locks.runWithLock(lock, task);
    }

    private static <T> T runWithLock(ClusterLock lock, Supplier<T> task) {
        lock.lock();
        try {
            Object object = task.get();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T readWithoutLock(ClusterLock lock, Supplier<T> task) {
        return (T)task.get();
    }
}

