/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.VendorId;
import com.atlassian.marketplace.client.model.Entity;
import com.atlassian.marketplace.client.model.ImageInfo;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.model.ReadOnly;
import com.atlassian.marketplace.client.model.RequiredLink;
import java.net.URI;

public abstract class VendorBase
implements Entity {
    Links _links;
    String name;
    @ReadOnly
    Option<String> verifiedStatus;
    @RequiredLink(rel="self")
    URI selfUri;
    @RequiredLink(rel="alternate")
    URI alternateUri;

    @Override
    public Links getLinks() {
        return this._links;
    }

    public VendorId getId() {
        return VendorId.fromUri(this.selfUri);
    }

    @Override
    public URI getSelfUri() {
        return this.selfUri;
    }

    public URI getAlternateUri() {
        return this.alternateUri;
    }

    public String getName() {
        return this.name;
    }

    public abstract Option<ImageInfo> getLogo();

    public boolean isVerified() {
        return "verified".equalsIgnoreCase((String)this.verifiedStatus.getOrElse((Object)""));
    }
}

