/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringEscapeUtils;

public class HtmlString {
    private final String value;

    private HtmlString(String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public static HtmlString html(String value) {
        return new HtmlString(value);
    }

    public String getHtml() {
        return this.value;
    }

    public String toString() {
        return "Html(" + StringEscapeUtils.escapeHtml((String)this.value) + ")";
    }

    public boolean equals(Object other) {
        return other instanceof HtmlString && ((HtmlString)other).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static Function<HtmlString, String> htmlToString() {
        return new Function<HtmlString, String>(){

            public String apply(HtmlString input) {
                return input.getHtml();
            }
        };
    }

    public static Function<String, HtmlString> stringToHtml() {
        return new Function<String, HtmlString>(){

            public HtmlString apply(String input) {
                return HtmlString.html(input);
            }
        };
    }
}

