/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.AddonQuery;
import com.atlassian.marketplace.client.api.AddonVersionSpecifier;
import com.atlassian.marketplace.client.api.AddonVersionsQuery;
import com.atlassian.marketplace.client.api.Addons;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.api.PricingType;
import com.atlassian.marketplace.client.api.UriTemplate;
import com.atlassian.marketplace.client.http.SimpleHttpResponse;
import com.atlassian.marketplace.client.impl.ApiHelper;
import com.atlassian.marketplace.client.impl.ApiImplBase;
import com.atlassian.marketplace.client.impl.InternalModel;
import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonPricing;
import com.atlassian.marketplace.client.model.AddonReference;
import com.atlassian.marketplace.client.model.AddonSummary;
import com.atlassian.marketplace.client.model.AddonVersion;
import com.atlassian.marketplace.client.model.AddonVersionSummary;
import com.atlassian.marketplace.client.util.UriBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.input.NullInputStream;

final class AddonsImpl
extends ApiImplBase
implements Addons {
    AddonsImpl(ApiHelper apiHelper, InternalModel.MinimalLinks root) throws MpacException {
        super(apiHelper, root, "addons");
    }

    @Override
    public Option<Addon> getByKey(String addonKey, AddonQuery query) throws MpacException {
        InternalModel.Addons collectionRep = this.getEmptyBaseCollectionRep();
        UriTemplate byKeyTemplate = ApiHelper.requireLinkUriTemplate(collectionRep.getLinks(), "byKey", InternalModel.Addons.class);
        UriBuilder uri = UriBuilder.fromUri(byKeyTemplate.resolve((Map<String, String>)ImmutableMap.of((Object)"addonKey", (Object)addonKey)));
        ApiHelper.addAddonQueryParams(query, uri);
        return this.apiHelper.getOptionalEntity(uri.build(), Addon.class);
    }

    @Override
    public Page<AddonSummary> find(AddonQuery query) throws MpacException {
        UriBuilder uri = this.fromApiRoot();
        ApiHelper.addAddonQueryParams(query, uri);
        return this.apiHelper.getMore(new PageReference(uri.build(), query.getBounds(), this.pageReader(InternalModel.Addons.class)));
    }

    @Override
    public Addon createAddon(Addon addon) throws MpacException {
        Function<URI, URI> resultUriTransform = new Function<URI, URI>(){

            public URI apply(URI uri) {
                return UriBuilder.fromUri(uri).queryParam("withVersion", true).build();
            }
        };
        return this.genericCreate(this.getApiRoot(), addon, resultUriTransform);
    }

    @Override
    public Addon updateAddon(Addon original, Addon updated) throws MpacException {
        return this.genericUpdate(original.getSelfUri(), original, updated);
    }

    @Override
    public Option<AddonVersion> getVersion(String addonKey, AddonVersionSpecifier version, AddonVersionsQuery query) throws MpacException {
        AddonQuery queryWithToken = ((AddonQuery.Builder)AddonQuery.builder().accessToken((Option)query.getAccessToken())).build();
        Iterator i$ = this.getByKey(addonKey, queryWithToken).iterator();
        if (i$.hasNext()) {
            Addon a = (Addon)i$.next();
            UriBuilder uri = UriBuilder.fromUri(this.getVersionUri(a, version, queryWithToken));
            ApiHelper.addAddonVersionsQueryParams(query, uri);
            return this.apiHelper.getOptionalEntity(uri.build(), AddonVersion.class);
        }
        return Option.none();
    }

    @Override
    public Page<AddonVersionSummary> getVersions(String addonKey, AddonVersionsQuery query) throws MpacException {
        Iterator i$ = this.getByKey(addonKey, ((AddonQuery.Builder)AddonQuery.builder().accessToken((Option)query.getAccessToken())).build()).iterator();
        if (i$.hasNext()) {
            Addon a = (Addon)i$.next();
            UriBuilder uri = UriBuilder.fromUri(this.getVersionsUri(a));
            ApiHelper.addAddonVersionsQueryParams(query, uri);
            return this.apiHelper.getMore(new PageReference(uri.build(), query.getBounds(), this.pageReader(InternalModel.AddonVersions.class)));
        }
        return Page.empty();
    }

    @Override
    public AddonVersion createVersion(String addonKey, AddonVersion version) throws MpacException {
        Iterator i$ = this.getByKey(addonKey, AddonQuery.any()).iterator();
        if (i$.hasNext()) {
            Addon a = (Addon)i$.next();
            return this.genericCreate(this.getVersionsUri(a), version);
        }
        throw new MpacException.ServerError(404);
    }

    @Override
    public AddonVersion updateVersion(AddonVersion original, AddonVersion updated) throws MpacException {
        return this.genericUpdate(original.getSelfUri(), original, updated);
    }

    @Override
    public Option<AddonPricing> getPricing(String addonKey, PricingType pricingType) throws MpacException {
        for (Addon a : this.getByKey(addonKey, AddonQuery.any())) {
            Iterator i$ = a.getPricingUri(pricingType).iterator();
            if (!i$.hasNext()) continue;
            URI uri = (URI)i$.next();
            return this.apiHelper.getOptionalEntity(uri, AddonPricing.class);
        }
        return Option.none();
    }

    @Override
    public Page<AddonReference> findBanners(AddonQuery query) throws MpacException {
        InternalModel.Addons collectionRep = this.getEmptyBaseCollectionRep();
        UriBuilder uri = UriBuilder.fromUri(this.apiHelper.requireLinkUri(collectionRep.getLinks(), "banners", collectionRep.getClass()));
        ApiHelper.addAddonQueryParams(query, uri);
        return this.apiHelper.getMore(new PageReference(uri.build(), query.getBounds(), this.pageReader(InternalModel.AddonReferences.class)));
    }

    @Override
    public Page<AddonReference> findRecommendations(String addonKey, AddonQuery query) throws MpacException {
        for (Addon a : this.getByKey(addonKey, AddonQuery.any())) {
            Iterator i$ = a.getLinks().getUri("recommendations").iterator();
            if (!i$.hasNext()) continue;
            URI u = (URI)i$.next();
            UriBuilder uri = UriBuilder.fromUri(u);
            ApiHelper.addAddonQueryParams(query, uri);
            return this.apiHelper.getMore(new PageReference(uri.build(), query.getBounds(), this.pageReader(InternalModel.AddonReferences.class)));
        }
        return Page.empty();
    }

    @Override
    public boolean claimAccessToken(String addonKey, String token) throws MpacException {
        Option<Addon> addon;
        try {
            addon = this.getByKey(addonKey, ((AddonQuery.Builder)AddonQuery.builder().accessToken(Option.some((Object)token))).build());
        }
        catch (MpacException.ServerError e) {
            int status = e.getStatus();
            if (status >= 400 && status < 500) {
                return false;
            }
            throw e;
        }
        for (Addon a : addon) {
            Iterator i$ = a.getLinks().getUri("tokens").iterator();
            if (!i$.hasNext()) continue;
            URI collUri = (URI)i$.next();
            InternalModel.MinimalLinks rep = this.apiHelper.getEntity(ApiHelper.withZeroLimit(ApiHelper.withAccessToken(collUri, token)), InternalModel.MinimalLinks.class);
            UriTemplate t = ApiHelper.requireLinkUriTemplate(rep.getLinks(), "byToken", rep.getClass());
            URI uri = this.apiHelper.resolveLink(t.resolve((Map<String, String>)ImmutableMap.of((Object)"token", (Object)token)));
            try (SimpleHttpResponse r = this.apiHelper.getHttp().post(uri, (InputStream)new NullInputStream(0L), 0L, "application/json", "application/json");){
                switch (r.getStatus()) {
                    case 200: 
                    case 204: {
                        boolean bl = true;
                        return bl;
                    }
                    case 400: 
                    case 403: 
                    case 404: {
                        boolean bl = false;
                        return bl;
                    }
                }
                throw this.apiHelper.responseException(r);
            }
        }
        return false;
    }

    private InternalModel.Addons getEmptyBaseCollectionRep() throws MpacException {
        return this.apiHelper.getEntity(ApiHelper.withZeroLimit(this.getApiRoot()), InternalModel.Addons.class);
    }

    private InternalModel.AddonVersions getEmptyVersionCollectionRep(Addon a, AddonQuery query) throws MpacException {
        UriBuilder uri = UriBuilder.fromUri(this.getVersionsUri(a));
        ApiHelper.addAddonQueryParams(query, uri);
        return this.apiHelper.getEntity(ApiHelper.withZeroLimit(uri.build()), InternalModel.AddonVersions.class);
    }

    private URI getVersionsUri(Addon a) throws MpacException {
        return this.apiHelper.requireLinkUri(a.getLinks(), "versions", Addon.class);
    }

    private URI getVersionUri(Addon a, AddonVersionSpecifier v, AddonQuery query) throws MpacException {
        InternalModel.AddonVersions collectionRep = this.getEmptyVersionCollectionRep(a, query);
        for (Either specifiedVersion : v.getSpecifiedVersion()) {
            Iterator i$ = specifiedVersion.left().iterator();
            if (i$.hasNext()) {
                String name = (String)i$.next();
                return ApiHelper.getTemplatedLink(collectionRep, "byName", "name", name);
            }
            i$ = specifiedVersion.right().iterator();
            if (!i$.hasNext()) continue;
            Long build = (Long)i$.next();
            return ApiHelper.getTemplatedLink(collectionRep, "byBuild", "pluginBuildNumber", String.valueOf(build));
        }
        return this.apiHelper.requireLinkUri(collectionRep.getLinks(), "latest", InternalModel.AddonVersions.class);
    }
}

