/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.AddonCategories;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Applications;
import com.atlassian.marketplace.client.impl.ApiHelper;
import com.atlassian.marketplace.client.impl.InternalModel;
import com.atlassian.marketplace.client.model.AddonCategorySummary;
import com.atlassian.marketplace.client.model.Application;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;

final class AddonCategoriesImpl
implements AddonCategories {
    private final ApiHelper apiHelper;
    private final Applications applicationsApi;

    AddonCategoriesImpl(ApiHelper apiHelper, Applications applicationsApi) {
        this.apiHelper = apiHelper;
        this.applicationsApi = applicationsApi;
    }

    @Override
    public Iterable<AddonCategorySummary> findForApplication(ApplicationKey appKey) throws MpacException {
        Iterator i$ = this.applicationsApi.getByKey(appKey).iterator();
        if (i$.hasNext()) {
            Application a = (Application)i$.next();
            URI uri = this.apiHelper.requireLinkUri(a.getLinks(), "addonCategories", Application.class);
            InternalModel.AddonCategories listRep = this.apiHelper.getEntity(uri, InternalModel.AddonCategories.class);
            return ImmutableList.copyOf(listRep._embedded.categories);
        }
        return ImmutableList.of();
    }
}

