AJS.toInit(function() {
	var baseUrl = AJS.$("meta[name='application-base-url']").attr("content");
	if (!baseUrl) {
		baseUrl = AJS.$("input[title='baseURL']").val();	
	}
	
    var postUrl = baseUrl + "/plugins/servlet/jiraconnect/deviceConfiguration";
 
	function _message(typ, title, msg, contextId) {
		AJS.$("#configMessage").remove();
		AJS.messages[typ]("#" + contextId + "-aui-message-bar", {
		   //title: title,
		   body: "<p>" + msg + "</p>",
		   fadeout: true,
		   delay: 3000,
		   id: "configMessage"
		});	
	}
	
	function _errorMessage(msg, contextId) {
		_message("error", "Error", msg, contextId);
	}
	
	function _successMessage(msg, contextId) {
		_message("success", "Success", msg, contextId);
	}
	
	function postConfigChange(e) {
		var contextId = e.currentTarget.id;
		AJS.$("#configMessage").remove();
		AJS.$.ajax({
			url: postUrl,
			type: "POST",
			dataType: "text",
			data: {
				setting: contextId,
				value: e.val				
			},
			success: function(config) {
				_successMessage("Setting updated", contextId);
			},
			error: function() {
				_errorMessage("Setting update failed", contextId);
			}
		});
	}
	
	var deviceConfigs = AJS.$("[name='deviceConfig']");
	if (deviceConfigs.length) {
		deviceConfigs.each(function() {
			var elem = AJS.$(this);
			if (elem.prop("tagName") == "SELECT") {
				elem.select2({
					minimumResultsForSearch: Infinity					
				});
				elem.on("change", postConfigChange);
			}
		});
	}
});