/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.ui;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import net.luethi.plugins.jiraconnect.Configuration;
import net.luethi.plugins.jiraconnect.ao.Device;

public final class DeviceListServlet
extends HttpServlet {
    private static final long serialVersionUID = 12345L;
    private final ActiveObjects ao;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final PluginLicenseManager licenseManager;

    public DeviceListServlet(ActiveObjects ao, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager licenseManager) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.licenseManager = licenseManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String licenseStatus;
        String username = this.userManager.getRemoteUsername(req);
        JiraAuthenticationContext authCtx = ComponentAccessor.getJiraAuthenticationContext();
        if (username == null || !this.userManager.isSystemAdmin(username) || !authCtx.isLoggedInUser()) {
            this.redirectToLogin(req, res);
            return;
        }
        String action = req.getParameter("action");
        final String user = req.getParameter("user");
        final String deviceId = req.getParameter("device");
        if (action != null && action.equals("delete")) {
            this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    for (Device device : (Device[])DeviceListServlet.this.ao.find(Device.class, "DEVICE_ID = ? AND USER_NAME = ?", new Object[]{deviceId, user})) {
                        DeviceListServlet.this.ao.delete(new RawEntity[]{device});
                    }
                    return null;
                }
            });
        }
        final ArrayList deviceList = new ArrayList();
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                for (Device device : (Device[])DeviceListServlet.this.ao.find(Device.class)) {
                    deviceList.add(device);
                }
                return null;
            }
        });
        try {
            PluginLicense pluginLicense;
            licenseStatus = this.licenseManager.getLicense().isDefined() ? ((pluginLicense = (PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined() ? ((LicenseError)pluginLicense.getError().get()).name() : "Valid") : "No valid license";
        }
        catch (Exception e) {
            licenseStatus = "Plugin license storage unavailable";
        }
        HashMap context = Maps.newHashMap();
        context.put("list", deviceList);
        context.put("license", licenseStatus);
        context.put("isDebug", Configuration.isDebug);
        res.setContentType("text/html;charset=utf-8");
        this.renderer.render("DeviceListServlet.vm", (Map)context, (Writer)res.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        final String user = req.getParameter("user");
        final String deviceId = req.getParameter("deviceId");
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Device>(){

            public Device doInTransaction() {
                Device device = (Device)DeviceListServlet.this.ao.create(Device.class, new DBParam[0]);
                device.setUserName(user);
                device.setDeviceId(deviceId);
                device.save();
                return device;
            }
        });
        res.sendRedirect(req.getContextPath() + "/plugins/servlet/jiraconnect/list");
    }
}

