/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.ui;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.ao.DBParam;
import net.luethi.plugins.jiraconnect.ao.DeviceConfiguration;

public final class DeviceConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 12345L;
    private final ActiveObjects ao;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final PluginLicenseManager licenseManager;

    public DeviceConfigServlet(ActiveObjects ao, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager licenseManager) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.licenseManager = licenseManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean allowStoringPasswordOnDevice;
        String licenseStatus;
        String username = this.userManager.getRemoteUsername(req);
        JiraAuthenticationContext authCtx = ComponentAccessor.getJiraAuthenticationContext();
        if (username == null || !this.userManager.isSystemAdmin(username) || !authCtx.isLoggedInUser()) {
            this.redirectToLogin(req, res);
            return;
        }
        String action = req.getParameter("action");
        String user = req.getParameter("user");
        String deviceId = req.getParameter("device");
        try {
            PluginLicense pluginLicense;
            licenseStatus = this.licenseManager.getLicense().isDefined() ? ((pluginLicense = (PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined() ? ((LicenseError)pluginLicense.getError().get()).name() : "Valid") : "No valid license";
        }
        catch (Exception e) {
            licenseStatus = "Plugin license storage unavailable";
        }
        DeviceConfiguration config = null;
        try {
            DeviceConfiguration[] deviceConfigurations = (DeviceConfiguration[])this.ao.find(DeviceConfiguration.class);
            if (deviceConfigurations.length > 0) {
                config = deviceConfigurations[0];
            }
        }
        catch (Exception deviceConfigurations) {
            // empty catch block
        }
        boolean bl = config != null ? (config.getallowStoringPassword() == null ? true : config.getallowStoringPassword()) : (allowStoringPasswordOnDevice = true);
        boolean allowCachingOnDevice = config != null ? (config.getAllowCachingOnDevice() == null ? true : config.getAllowCachingOnDevice()) : true;
        HashMap context = Maps.newHashMap();
        context.put("license", licenseStatus);
        context.put("allowStoringPasswordOnDevice", allowStoringPasswordOnDevice ? 1 : 0);
        context.put("allowCachingOnDevice", allowCachingOnDevice ? 1 : 0);
        res.setContentType("text/html;charset=utf-8");
        this.renderer.render("DeviceConfigServlet.vm", (Map)context, (Writer)res.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String username = this.userManager.getRemoteUsername(req);
        JiraAuthenticationContext authCtx = ComponentAccessor.getJiraAuthenticationContext();
        if (username == null || !this.userManager.isSystemAdmin(username) || !authCtx.isLoggedInUser()) {
            res.setStatus(500);
            return;
        }
        final String setting = req.getParameter("setting");
        final String value = req.getParameter("value");
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<DeviceConfiguration>(){

            public DeviceConfiguration doInTransaction() {
                DeviceConfiguration config = null;
                try {
                    DeviceConfiguration[] deviceConfigurations = (DeviceConfiguration[])DeviceConfigServlet.this.ao.find(DeviceConfiguration.class);
                    config = deviceConfigurations.length > 0 ? deviceConfigurations[0] : (DeviceConfiguration)DeviceConfigServlet.this.ao.create(DeviceConfiguration.class, new DBParam[0]);
                    if (config != null) {
                        if (setting.equals("allowStoringPasswordOnDevice")) {
                            config.setAllowStoringPassword(value.equals("1"));
                        } else if (setting.equals("allowCachingOnDevice")) {
                            config.setAllowCachingOnDevice(value.equals("1"));
                        }
                        config.save();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return config;
            }
        });
        res.setStatus(200);
    }
}

