/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.luethi.plugins.jiraconnect.Configuration;
import net.luethi.plugins.jiraconnect.ao.Device;
import net.luethi.plugins.jiraconnect.ao.DeviceConfiguration;
import net.luethi.plugins.jiraconnect.rest.ConfigurationModel;
import net.luethi.plugins.jiraconnect.rest.InfoModel;
import net.luethi.plugins.jiraconnect.rest.RegisterDeviceModel;
import net.luethi.plugins.jiraconnect.rest.SimpleDevice;

@Path(value="/device")
public class RegisterDevice {
    private final ActiveObjects ao;
    private final String version = "1.0";
    private final int build = 1;
    private final String name = "jiraconnect";
    private final PluginLicenseManager licenseManager;

    public RegisterDevice(ActiveObjects ao, PluginLicenseManager licenseManager) {
        this.ao = ao;
        this.licenseManager = licenseManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="info")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getApiInfo(@QueryParam(value="guid") String guid) {
        boolean isValidLicense = false;
        String messageDigest = null;
        String salt = "jalsdkf90@#";
        guid = guid + salt;
        try {
            PluginLicense pluginLicense;
            if (this.licenseManager.getLicense().isDefined() && !(pluginLicense = (PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined() && !pluginLicense.isMaintenanceExpired()) {
                isValidLicense = true;
            }
        }
        catch (Exception pluginLicense) {
            // empty catch block
        }
        if (!Configuration.requireLicense) {
            isValidLicense = true;
        }
        if (isValidLicense) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] mesDig = md.digest(guid.getBytes());
                messageDigest = DatatypeConverter.printHexBinary((byte[])mesDig);
                System.out.println("Received:" + guid);
                System.out.println("Calculated:" + messageDigest);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        InfoModel model = new InfoModel();
        model.setVersion("1.0");
        model.setBuild(1);
        model.setName("jiraconnect");
        model.setGuid(messageDigest);
        model.setValidLicense(isValidLicense);
        ConfigurationModel configurationModel = new ConfigurationModel();
        DeviceConfiguration devConfig = this.getDeviceConfiguration();
        if (devConfig == null) {
            DeviceConfiguration newDevConfig = (DeviceConfiguration)this.ao.create(DeviceConfiguration.class, new DBParam[0]);
            newDevConfig.setAllowStoringPassword(true);
            newDevConfig.setAllowCachingOnDevice(true);
            newDevConfig.save();
            configurationModel.setallowStoringPasswordOnDevice(true);
            configurationModel.setAllowCachingOnDevice(true);
        } else {
            boolean allowStoringPassword = devConfig.getallowStoringPassword() == null ? true : devConfig.getallowStoringPassword();
            boolean allowCaching = devConfig.getAllowCachingOnDevice() == null ? true : devConfig.getAllowCachingOnDevice();
            configurationModel.setallowStoringPasswordOnDevice(allowStoringPassword);
            configurationModel.setAllowCachingOnDevice(allowCaching);
        }
        model.setConfiguration(configurationModel);
        return Response.status((int)200).entity((Object)model).build();
    }

    @GET
    @Path(value="{deviceId}/{userName}")
    @Produces(value={"application/json", "application/xml"})
    public Response getMessage(@PathParam(value="deviceId") String deviceId, @PathParam(value="userName") String userName) {
        Device device = this.getDevice(deviceId, userName);
        if (device != null) {
            RegisterDeviceModel model = new RegisterDeviceModel();
            model.setDeviceId(device.getDeviceId());
            model.setUserName(device.getUserName());
            model.setAppId(device.getAppId());
            model.setDeviceType(device.getDeviceType());
            model.setProfileId(device.getProfileId());
            model.setIssueCreated(device.isIssueCreated());
            model.setIssueAssigned(device.isIssueAssigned());
            model.setIssueResolved(device.isIssueResolved());
            model.setIssueReopened(device.isIssueReopened());
            model.setIssueClosed(device.isIssueClosed());
            model.setIssueDeleted(device.isIssueDeleted());
            model.setCommentAdded(device.isCommentAdded());
            model.setIssueUpdated(device.isIssueUpdated());
            model.setCommentModified(device.isCommentModified());
            model.setWorklogAdded(device.isWorklogAdded());
            model.setIssueMoved(device.isIssueMoved());
            model.setWorkStarted(device.isWorkStarted());
            model.setWorkStopped(device.isWorkStopped());
            model.setGenericEvent(device.isGenericEvent());
            model.setWorklogUpdated(device.isWorklogUpdated());
            model.setWorklogDeleted(device.isWorklogDeleted());
            model.setLastAccessed(device.getLastAccessed());
            return Response.ok((Object)model).build();
        }
        return Response.status((int)201).entity((Object)"no device found").build();
    }

    @PUT
    @Path(value="{deviceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response updateDevice(@PathParam(value="deviceId") String deviceId, SimpleDevice dev) {
        Device[] devices = (Device[])this.ao.find(Device.class, Query.select().where("DEVICE_ID = ? AND USER_NAME = ?", new Object[]{dev.deviceId, dev.userName}));
        if (Configuration.isDebug) {
            System.out.println(dev.userName);
            System.out.println(dev.deviceId);
        }
        if (devices.length == 0) {
            return Response.status((int)201).entity((Object)"device not registered").build();
        }
        Device device = devices[0];
        device.setIssueCreated(dev.issueCreated);
        device.setIssueAssigned(dev.issueAssigned);
        device.setIssueResolved(dev.issueResolved);
        device.setIssueReopened(dev.issueReopened);
        device.setIssueClosed(dev.issueClosed);
        device.setIssueDeleted(dev.issueDeleted);
        device.setCommentAdded(dev.commentAdded);
        device.setIssueUpdated(dev.issueUpdated);
        device.setCommentModified(dev.commentModified);
        device.setWorklogAdded(dev.worklogAdded);
        device.setIssueMoved(dev.issueMoved);
        device.setWorkStarted(dev.workStarted);
        device.setWorkStopped(dev.workStopped);
        device.setGenericEvent(dev.genericEvent);
        device.setWorklogUpdated(dev.worklogUpdated);
        device.setWorklogDeleted(dev.worklogDeleted);
        device.setLastAccessed(new Date());
        device.setBadgeNumber(0);
        device.save();
        return Response.status((int)200).entity((Object)("device: " + dev.deviceId + " user:" + dev.userName)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{deviceId}")
    public Response addDevice(@PathParam(value="deviceId") String deviceId, SimpleDevice dev) {
        Device[] devices = (Device[])this.ao.find(Device.class, Query.select().where("DEVICE_ID = ? AND USER_NAME = ?", new Object[]{deviceId, dev.userName}));
        if (Configuration.isDebug) {
            System.out.println("POST - num of devices: " + devices.length);
        }
        if (devices.length > 0) {
            devices[0].setLastAccessed(new Date());
            devices[0].setActive(true);
            devices[0].setBadgeNumber(0);
            devices[0].save();
            return Response.status((int)201).entity((Object)"device already registered").build();
        }
        Device device = (Device)this.ao.create(Device.class, new DBParam[0]);
        device.setUserName(dev.userName);
        device.setDeviceId(deviceId);
        device.setAppId(dev.appId);
        device.setProfileId(dev.profileId);
        device.setDeviceType(dev.deviceType);
        device.setIssueCreated(true);
        device.setIssueAssigned(true);
        device.setIssueResolved(true);
        device.setIssueReopened(true);
        device.setIssueClosed(true);
        device.setIssueDeleted(true);
        device.setCommentAdded(true);
        device.setIssueUpdated(true);
        device.setCommentModified(true);
        device.setWorklogAdded(true);
        device.setIssueMoved(true);
        device.setWorkStarted(true);
        device.setWorkStopped(true);
        device.setGenericEvent(true);
        device.setWorklogUpdated(true);
        device.setWorklogDeleted(true);
        device.setActive(true);
        device.setLastAccessed(new Date());
        device.setBadgeNumber(0);
        device.save();
        return Response.status((int)200).entity((Object)("device: " + dev.deviceId + " user:" + dev.userName)).build();
    }

    public Device getDevice(String deviceId, String userName) {
        Device[] devices = (Device[])this.ao.find(Device.class, Query.select().where("DEVICE_ID = ? AND USER_NAME = ?", new Object[]{deviceId, userName}));
        if (devices.length > 0) {
            return devices[0];
        }
        return null;
    }

    public DeviceConfiguration getDeviceConfiguration() {
        try {
            DeviceConfiguration[] config = (DeviceConfiguration[])this.ao.find(DeviceConfiguration.class);
            if (config.length > 0) {
                return config[0];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

