/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.rest;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.luethi.plugins.jiraconnect.rest.FieldModel;
import net.luethi.plugins.jiraconnect.rest.FormModel;
import net.luethi.plugins.jiraconnect.rest.TabModel;

@Path(value="/screen")
public class Forms {
    private final FieldManager fieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final TranslationManager translationManager;
    private final CustomFieldManager customFieldManager;

    public Forms(FieldManager fieldManager, FieldScreenManager fieldScreenManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, IssueManager issueManager, ProjectManager projectManager, ConstantsManager constantsManager, TranslationManager translationManager, CustomFieldManager customFieldManager) {
        this.fieldManager = fieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.translationManager = translationManager;
        this.customFieldManager = customFieldManager;
    }

    @GET
    @Path(value="{operation}/{issueKey}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getMessage(@PathParam(value="issueKey") String issueKey, @PathParam(value="operation") String operation, @QueryParam(value="locale") String localeString) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        FieldScreenScheme fieldScreenScheme = this.issueTypeScreenSchemeManager.getFieldScreenScheme((Issue)issue);
        FieldScreen screen = fieldScreenScheme.getFieldScreen((IssueOperation)this.getIssueOperation(operation));
        FormModel model = new FormModel();
        model.setFormId(screen.getId().intValue());
        model.setName(screen.getName());
        return Response.status((int)200).entity((Object)model).build();
    }

    private ScreenableIssueOperation getIssueOperation(String operation) {
        if (operation.equals("edit")) {
            return IssueOperations.EDIT_ISSUE_OPERATION;
        }
        if (operation.equals("create")) {
            return IssueOperations.CREATE_ISSUE_OPERATION;
        }
        return IssueOperations.VIEW_ISSUE_OPERATION;
    }

    @GET
    @Path(value="{operation}/{projectKey}/{issueTypeId}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getFormByIssueType(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="operation") String operation, @PathParam(value="projectKey") String projectKey, @QueryParam(value="locale") String localeString) {
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project);
        IssueType issueType = this.constantsManager.getIssueTypeObject(issueTypeId);
        FieldScreenScheme fieldScreenScheme = issueTypeScreenScheme.getEffectiveFieldScreenScheme(issueType);
        FieldScreen screen = fieldScreenScheme.getFieldScreen((IssueOperation)this.getIssueOperation(operation));
        List fieldScreenTabs = this.fieldScreenManager.getFieldScreenTabs(screen);
        FormModel model = new FormModel();
        ArrayList<TabModel> tabModels = new ArrayList<TabModel>();
        for (FieldScreenTab tab : fieldScreenTabs) {
            List fieldScreenLayoutItems = tab.getFieldScreenLayoutItems();
            TabModel tabModel = new TabModel();
            tabModel.setName(tab.getName());
            ArrayList<FieldModel> fieldModels = new ArrayList<FieldModel>();
            tabModel.setFields(fieldModels);
            tabModels.add(tabModel);
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenLayoutItems) {
                OrderableField orderableField = fieldScreenLayoutItem.getOrderableField();
                if (orderableField == null) continue;
                FieldModel fieldModel = new FieldModel();
                fieldModel.setId(orderableField.getId());
                try {
                    CustomField customField = this.customFieldManager.getCustomFieldObject(orderableField.getId());
                    Locale locale = Locale.forLanguageTag(localeString);
                    String translatedFieldName = this.translationManager.getCustomFieldNameTranslation(customField, locale);
                    if (translatedFieldName.equals("")) {
                        fieldModel.setName(orderableField.getName());
                    } else {
                        fieldModel.setName(translatedFieldName);
                    }
                }
                catch (Exception e) {
                    fieldModel.setName(orderableField.getName());
                }
                fieldModels.add(fieldModel);
            }
        }
        model.setFormId(screen.getId().intValue());
        model.setName(screen.getName());
        model.setTabs(tabModels);
        return Response.status((int)200).entity((Object)model).build();
    }
}

