/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.rest;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.luethi.plugins.jiraconnect.rest.CustomFieldContextModel;

@Path(value="/customfieldcontext")
public class CustomFieldContext {
    private final FieldManager fieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final TranslationManager translationManager;
    private final CustomFieldManager customFieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    public CustomFieldContext(FieldManager fieldManager, FieldScreenManager fieldScreenManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, IssueManager issueManager, ProjectManager projectManager, ConstantsManager constantsManager, TranslationManager translationManager, CustomFieldManager customFieldManager, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.fieldManager = fieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.translationManager = translationManager;
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @GET
    @Path(value="project/{projectKey}/customfield/{customFieldId}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getMessage(@PathParam(value="customFieldId") Long customFieldId, @PathParam(value="projectKey") String projectKey) {
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField != null) {
            FieldConfigScheme fieldConfigScheme = this.fieldConfigSchemeManager.getRelevantConfigScheme(project, (ConfigurableField)customField);
            FieldConfig fieldConfig = fieldConfigScheme.getOneAndOnlyConfig();
            CustomFieldContextModel model = new CustomFieldContextModel();
            model.setCustomFieldContextId(fieldConfig.getId());
            model.setCustomFieldId(customFieldId);
            model.setProjectKey(projectKey);
            return Response.status((int)200).entity((Object)model).build();
        }
        return Response.status((int)404).entity(null).build();
    }
}

