/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.listener;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.java.ao.Query;
import net.luethi.plugins.jiraconnect.Configuration;
import net.luethi.plugins.jiraconnect.ao.Device;
import net.luethi.plugins.jiraconnect.apn.APNService;
import net.luethi.plugins.jiraconnect.apn.GCMService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class IssueCreatedResolvedListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final ActiveObjects ao;
    private final PluginLicenseManager licenseManager;

    public IssueCreatedResolvedListener(EventPublisher eventPublisher, ActiveObjects ao, PluginLicenseManager licenseManager) {
        this.eventPublisher = eventPublisher;
        this.ao = ao;
        this.licenseManager = licenseManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        Long eventTypeId = issueEvent.getEventTypeId();
        Issue issue = issueEvent.getIssue();
        ApplicationUser initiatingUser = issueEvent.getUser();
        IssueManager manager = ComponentAccessor.getIssueManager();
        ArrayList<User> usersToNotify = new ArrayList<User>();
        if (initiatingUser instanceof ApplicationUser) {
            usersToNotify.addAll(manager.getWatchersFor(issue));
        } else {
            usersToNotify.addAll(manager.getWatchers(issue));
        }
        if (issue.getAssignee() != null) {
            usersToNotify.add((User)issue.getAssignee());
        }
        if (issue.getReporter() != null) {
            usersToNotify.add((User)issue.getReporter());
        }
        HashSet<User> hash = new HashSet<User>();
        hash.addAll(usersToNotify);
        usersToNotify.clear();
        usersToNotify.addAll(hash);
        usersToNotify.remove(initiatingUser);
        if (!usersToNotify.isEmpty()) {
            String displayName = initiatingUser instanceof ApplicationUser ? initiatingUser.getDisplayName() : ((User)initiatingUser).getDisplayName();
            Device[] devices = this.getDevicesToNotify(usersToNotify, eventTypeId);
            String message = new String();
            String trcSummary = IssueCreatedResolvedListener.truncate(issue.getSummary(), 80);
            message = eventTypeId.equals(EventType.ISSUE_ASSIGNED_ID) ? (issue.getAssignee() == null ? String.format("%s (%s) has been assigned", issue.getKey(), trcSummary) : String.format("%s (%s) has been assigned to %s", issue.getKey(), trcSummary, issue.getAssignee().getDisplayName())) : (eventTypeId.equals(EventType.ISSUE_CLOSED_ID) ? (issue.getAssignee() == null ? String.format("%s (%s) has been closed", issue.getKey(), trcSummary) : String.format("%s (%s) assigned to %s has been closed", issue.getKey(), trcSummary, issue.getAssignee().getDisplayName())) : (eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID) ? String.format("%s (%s) a comment has been edited", issue.getKey(), trcSummary) : (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID) ? String.format("%s (%s) has been commented on by %s", issue.getKey(), trcSummary, displayName) : (eventTypeId.equals(EventType.ISSUE_CREATED_ID) ? (issue.getAssignee() == null ? String.format("%s (%s) has been created", issue.getKey(), trcSummary) : String.format("%s (%s) has been created and assigned to %s", issue.getKey(), trcSummary, issue.getAssignee().getDisplayName())) : (eventTypeId.equals(EventType.ISSUE_DELETED_ID) ? String.format("%s (%s) has been deleted", issue.getKey(), trcSummary) : (eventTypeId.equals(EventType.ISSUE_GENERICEVENT_ID) ? String.format("%s (%s) generic event", issue.getKey(), trcSummary) : (eventTypeId.equals(EventType.ISSUE_MOVED_ID) ? (issue.getAssignee() == null ? String.format("%s (%s) has been moved", issue.getKey(), trcSummary) : String.format("%s (%s) assigned to %s has been moved", issue.getKey(), trcSummary, issue.getAssignee().getDisplayName())) : (eventTypeId.equals(EventType.ISSUE_REOPENED_ID) ? (issue.getAssignee() == null ? String.format("%s (%s) has been reopened", issue.getKey(), trcSummary) : String.format("%s (%s) assigned to %s has been reopened", issue.getKey(), trcSummary, issue.getAssignee().getDisplayName())) : (eventTypeId.equals(EventType.ISSUE_RESOLVED_ID) ? (issue.getAssignee() == null ? String.format("%s (%s) has been resolved", issue.getKey(), trcSummary) : String.format("%s (%s) assigned to %s has been resolved", issue.getKey(), trcSummary, issue.getAssignee().getDisplayName())) : (eventTypeId.equals(EventType.ISSUE_UPDATED_ID) ? String.format("%s (%s) has been updated by %s", issue.getKey(), trcSummary, displayName) : (eventTypeId.equals(EventType.ISSUE_WORKLOG_DELETED_ID) ? String.format("%s (%s) a worklog has been deleted", issue.getKey(), trcSummary) : (eventTypeId.equals(EventType.ISSUE_WORKLOG_UPDATED_ID) ? String.format("%s (%s) a worklog has been updated", issue.getKey(), trcSummary) : (eventTypeId.equals(EventType.ISSUE_WORKLOGGED_ID) ? String.format("%s (%s) work has been logged by %s", issue.getKey(), trcSummary, displayName) : (eventTypeId.equals(EventType.ISSUE_WORKSTARTED_ID) ? String.format("%s (%s) work has been started", issue.getKey(), trcSummary) : (eventTypeId.equals(EventType.ISSUE_WORKSTOPPED_ID) ? String.format("%s (%s) work has stopped", issue.getKey(), trcSummary) : String.format("%s (%s) has been modified", issue.getKey(), trcSummary))))))))))))))));
            if (Configuration.isDebug) {
                System.out.println("Eventype: " + eventTypeId);
                System.out.println("License is valid: " + this.isValidLicense());
                System.out.println("Devices: " + devices.length);
                System.out.println("Users to notify: " + usersToNotify.size());
            }
            APNService srv = new APNService();
            GCMService gcm = new GCMService();
            ArrayList<String> androidDevices = new ArrayList<String>();
            ArrayList<String> iosDevices = new ArrayList<String>();
            if (devices.length > 0 && this.isValidLicense()) {
                for (Device device : devices) {
                    Date lastAccess = device.getLastAccessed();
                    Date now = new Date();
                    long threshold = Configuration.disableThreshold;
                    long nowTime = now.getTime();
                    long lastAccessTime = lastAccess.getTime();
                    if (Configuration.isDebug) {
                        System.out.println("Now: " + nowTime);
                        System.out.println("Last: " + lastAccessTime);
                    }
                    if (nowTime - lastAccessTime > threshold) {
                        if (Configuration.isDebug) {
                            System.out.println("Inactivate device: " + device.getDeviceId());
                        }
                        device.setActive(false);
                        device.save();
                    }
                    if (!device.isActive()) continue;
                    if (device.getDeviceType().equalsIgnoreCase("Android")) {
                        androidDevices.add(device.getDeviceId());
                        gcm.sendSingleMessage(message, device.getDeviceId(), issue.getKey(), eventTypeId, device.getProfileId(), device.getAppId());
                        continue;
                    }
                    iosDevices.add(device.getDeviceId());
                    device.setBadgeNumber(device.getBadgeNumber() + 1);
                    device.save();
                    if (Configuration.isDebug) {
                        System.out.println("App: " + device.getAppId());
                        System.out.println("Badges: " + device.getBadgeNumber());
                    }
                    srv.createPayloads(device.getDeviceId(), message, issue.getKey(), eventTypeId, device.getProfileId(), device.getAppId(), device.getBadgeNumber());
                }
                if (iosDevices.size() > 0) {
                    srv.pushPayloads();
                }
            }
        }
    }

    public Device[] getDevicesToNotify(List<User> users, long eventTypeId) {
        ArrayList<String> userNames = new ArrayList<String>();
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(EventType.ISSUE_CREATED_ID, "ISSUE_CREATED");
        map.put(EventType.ISSUE_UPDATED_ID, "ISSUE_UPDATED");
        map.put(EventType.ISSUE_ASSIGNED_ID, "ISSUE_ASSIGNED");
        map.put(EventType.ISSUE_RESOLVED_ID, "ISSUE_RESOLVED");
        map.put(EventType.ISSUE_REOPENED_ID, "ISSUE_REOPENED");
        map.put(EventType.ISSUE_CLOSED_ID, "ISSUE_CLOSED");
        map.put(EventType.ISSUE_DELETED_ID, "ISSUE_DELETED");
        map.put(EventType.ISSUE_MOVED_ID, "ISSUE_MOVED");
        map.put(EventType.ISSUE_COMMENTED_ID, "COMMENT_ADDED");
        map.put(EventType.ISSUE_COMMENT_EDITED_ID, "COMMENT_MODIFIED");
        map.put(EventType.ISSUE_WORKLOGGED_ID, "WORKLOG_ADDED");
        map.put(EventType.ISSUE_WORKSTARTED_ID, "WORK_STARTED");
        map.put(EventType.ISSUE_WORKSTOPPED_ID, "WORK_STOPPED");
        map.put(EventType.ISSUE_WORKLOG_UPDATED_ID, "WORKLOG_UPDATED");
        map.put(EventType.ISSUE_WORKLOG_DELETED_ID, "WORKLOG_DELETED");
        map.put(EventType.ISSUE_GENERICEVENT_ID, "GENERIC_EVENT");
        String eventCondition = map.get(eventTypeId) != null ? (Configuration.isDebug ? String.format("%s = 1", map.get(eventTypeId)) : String.format("%s = '1'", map.get(eventTypeId))) : "1=1";
        for (User u : users) {
            if (u == null) continue;
            if (u instanceof ApplicationUser) {
                userNames.add(((ApplicationUser)u).getName());
                continue;
            }
            userNames.add(u.getName());
        }
        String placeholderCommaList = Joiner.on((String)", ").join(Iterables.transform(userNames, (Function)Functions.constant((Object)"?")));
        Object[] matchValuesArray = Iterables.toArray(userNames, String.class);
        Device[] devices = (Device[])this.ao.find(Device.class, Query.select().where("USER_NAME IN (" + placeholderCommaList + ") AND " + eventCondition, matchValuesArray));
        if (Configuration.isDebug) {
            System.out.println("Event Type: " + eventTypeId + "\nQuery: " + eventCondition);
            System.out.println("USER_NAME IN (" + placeholderCommaList + ") AND " + eventCondition);
            System.out.println("User names: " + userNames.toString());
            for (int i = 0; i < devices.length; ++i) {
                System.out.println("Sending APN to: " + devices[i].getUserName());
            }
        }
        return devices;
    }

    public ArrayList<Device> devicesToNotify(String assignee, Long eventTypeId) {
        final ArrayList<Device> devices = new ArrayList<Device>();
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                for (Device device : (Device[])IssueCreatedResolvedListener.this.ao.find(Device.class)) {
                    devices.add(device);
                }
                return null;
            }
        });
        return devices;
    }

    public boolean isValidLicense() {
        if (!Configuration.requireLicense) {
            return true;
        }
        try {
            if (this.licenseManager.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                return !pluginLicense.getError().isDefined();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String truncate(String value, int length) {
        if (value != null && value.length() > length) {
            value = value.substring(0, length) + "...";
        }
        return value;
    }
}

