/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.feedback;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.Query;
import net.luethi.plugins.jiraconnect.Configuration;
import net.luethi.plugins.jiraconnect.ao.Device;
import net.luethi.plugins.jiraconnect.feedback.Scheduler;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;

public class RemoveDevicesTask
implements PluginJob {
    private ActiveObjects ao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> jobDataMap) {
        ArrayList<String> rmDevices = new ArrayList<String>();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(Configuration.feedbackServiceUser, Configuration.feedbackServicePwd);
        httpclient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Scheduler scheduler = (Scheduler)jobDataMap.get(Scheduler.KEY);
        this.ao = scheduler.ao;
        try {
            HttpGet httpget = new HttpGet(Configuration.feedbackService);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            if (Configuration.isDebug) {
                System.out.println("executing request " + httpget.getURI());
                System.out.println("----------------------------------------");
                System.out.println(responseBody);
                System.out.println("----------------------------------------");
            }
            Pattern pattern = Pattern.compile("([0-9a-zA-Z]+)");
            Matcher matcher = pattern.matcher(responseBody);
            while (matcher.find()) {
                rmDevices.add(matcher.group());
            }
        }
        catch (ClientProtocolException e) {
            if (Configuration.isDebug) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            if (Configuration.isDebug) {
                e.printStackTrace();
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        if (Configuration.isDebug) {
            for (String token : rmDevices) {
                System.out.println(token);
            }
        }
        if (rmDevices.size() > 0) {
            this.removeDevices(rmDevices);
        }
    }

    public void removeDevices(ArrayList<String> inactiveDevices) {
        Device[] devices;
        String placeholderCommaList = Joiner.on((String)", ").join(Iterables.transform(inactiveDevices, (Function)Functions.constant((Object)"?")));
        Object[] matchValuesArray = Iterables.toArray(inactiveDevices, String.class);
        if (Configuration.isDebug) {
            System.out.println("DEVICE_ID IN (" + placeholderCommaList + ")");
        }
        for (Device inactiveDevice : devices = (Device[])this.ao.find(Device.class, Query.select().where("DEVICE_ID IN (" + placeholderCommaList + ")", matchValuesArray))) {
            inactiveDevice.setIssueCreated(false);
            inactiveDevice.setIssueAssigned(false);
            inactiveDevice.setIssueResolved(false);
            inactiveDevice.setIssueReopened(false);
            inactiveDevice.setIssueClosed(false);
            inactiveDevice.setIssueDeleted(false);
            inactiveDevice.setCommentAdded(false);
            inactiveDevice.setIssueUpdated(false);
            inactiveDevice.setCommentModified(false);
            inactiveDevice.setWorklogAdded(false);
            inactiveDevice.setIssueMoved(false);
            inactiveDevice.setWorkStarted(false);
            inactiveDevice.setWorkStopped(false);
            inactiveDevice.setGenericEvent(false);
            inactiveDevice.setWorklogUpdated(false);
            inactiveDevice.setWorklogDeleted(false);
            inactiveDevice.save();
            if (!Configuration.isDebug) continue;
            System.out.println("Found and deleted: " + inactiveDevice.getDeviceId());
        }
    }
}

