/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jiraconnect.apn;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javapns.Push;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.notification.Payload;
import javapns.notification.PayloadPerDevice;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import javapns.notification.ResponsePacket;
import net.luethi.plugins.jiraconnect.Configuration;
import org.json.JSONException;

public class APNService {
    private String passwd = Configuration.certificatePassword;
    boolean isProd = Configuration.isProduction;
    boolean isDebug = Configuration.isDebug;
    private List<PayloadPerDevice> payloadPairs = new ArrayList<PayloadPerDevice>();
    private Map<String, List<PayloadPerDevice>> appPayloadPairs = new HashMap<String, List<PayloadPerDevice>>();

    public void createPayloads(String token, String message, String issueKey, long eventType, int profileId, String appId, int badgeNumber) {
        PushNotificationPayload payload = PushNotificationPayload.alert(message);
        try {
            List<Object> item;
            payload.addSound("default");
            payload.addCustomDictionary("issueKey", issueKey);
            payload.addCustomDictionary("eventType", String.valueOf(eventType));
            payload.addCustomDictionary("profileId", profileId);
            payload.addBadge(badgeNumber);
            if (this.appPayloadPairs.containsKey(appId)) {
                item = this.appPayloadPairs.get(appId);
            } else {
                item = new ArrayList();
                this.appPayloadPairs.put(appId, item);
            }
            item.add(new PayloadPerDevice((Payload)payload, token));
            this.payloadPairs.add(new PayloadPerDevice((Payload)payload, token));
        }
        catch (JSONException e) {
            System.out.println("JSON exception: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (InvalidDeviceTokenFormatException e) {
            System.out.println("Invalid device token exception: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void getFeedback(String appName) {
        String certName = this.getCertificateName(appName);
        InputStream keystore = this.getClass().getResourceAsStream(certName);
        try {
            List<Device> inactiveDevices = Push.feedback(keystore, this.passwd, this.isProd);
            for (Device device : inactiveDevices) {
                System.out.println("Inactive device: " + device.getToken());
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        catch (KeystoreException e) {
            e.printStackTrace();
        }
    }

    public String getCertificateName(String appName) {
        if (this.isProd) {
            return "/" + appName + "-2017-prod.p12";
        }
        return "/" + appName + "-2017-dev.p12";
    }

    public void pushPayloads() {
        for (Map.Entry<String, List<PayloadPerDevice>> entry : this.appPayloadPairs.entrySet()) {
            String key = entry.getKey();
            String certName = this.getCertificateName(key);
            if (this.isDebug) {
                System.out.println("app id: " + key);
                System.out.println("cert name: " + certName);
            }
            final InputStream keystore = this.getClass().getResourceAsStream(certName);
            final boolean isProd = this.isProd;
            final List<PayloadPerDevice> payloadPairs = this.payloadPairs;
            new Thread(){

                @Override
                public void run() {
                    try {
                        PushedNotifications notifications = Push.payloads(keystore, APNService.this.passwd, isProd, Configuration.numOfThreats, payloadPairs);
                        for (PushedNotification n : notifications) {
                            if (n.isSuccessful()) {
                                ResponsePacket rsp;
                                if (APNService.this.isDebug) {
                                    System.out.println("APN message successfully sent to: " + n.getDevice().getToken());
                                }
                                if ((rsp = n.getResponse()) == null || !Configuration.isDebug) continue;
                                System.out.println("Response: " + rsp.getMessage());
                                continue;
                            }
                            Exception e = n.getException();
                            e.printStackTrace();
                            System.out.println("APN error");
                            ResponsePacket theErrorResponse = n.getResponse();
                            if (theErrorResponse == null) continue;
                            System.out.println(theErrorResponse.getMessage());
                        }
                    }
                    catch (CommunicationException e) {
                        System.out.println("Communication exception: " + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                    catch (KeystoreException e) {
                        System.out.println("Keystore exception: " + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }
}

