/*
 * Decompiled with CFR 0.152.
 */
package net.luethi.plugins.jira.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LicenseServlet
extends HttpServlet {
    private static final long serialVersionUID = 1234L;
    private static final String TEMPLATE = "license-admin.vm";
    private final PluginLicenseManager licenseManager;
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    public LicenseServlet(PluginLicenseManager licenseManager, ApplicationProperties applicationProperties, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserManager userManager, I18nResolver i18nResolver) {
        this.licenseManager = licenseManager;
        this.applicationProperties = applicationProperties;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUsername() == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        if (!this.hasAdminPermission()) {
            this.handleUnpermittedUser(req, resp);
            return;
        }
        Map<String, Object> context = this.initVelocityContext(resp);
        this.addEligibleMarketplaceButtons(context);
        this.renderer.render(TEMPLATE, context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUsername() == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        if (!this.hasAdminPermission()) {
            this.handleUnpermittedUser(req, resp);
            return;
        }
        Map<String, Object> context = this.initVelocityContext(resp);
        if (!context.containsKey("errorMessage")) {
            // empty if block
        }
        this.addEligibleMarketplaceButtons(context);
        this.renderer.render(TEMPLATE, context, (Writer)resp.getWriter());
    }

    private Map<String, Object> initVelocityContext(HttpServletResponse resp) {
        resp.setContentType("text/html;charset=utf-8");
        URI servletUri = URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/net.luethi.plugins.jira.jiraconnect/license");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("servletUri", servletUri);
        context.put("displayLicenseAdminUi", true);
        try {
            context.put("license", this.licenseManager.getLicense());
            context.put("pluginKey", this.licenseManager.getPluginKey());
        }
        catch (Exception e) {
            context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.plugin.unavailable"));
            context.put("displayLicenseAdminUi", false);
        }
        return context;
    }

    private void addEligibleMarketplaceButtons(Map<String, Object> context) {
        URI servletUri = URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/net.luethi.plugins.jira.jiraconnect/license");
    }

    private boolean hasAdminPermission() {
        String user = this.userManager.getRemoteUsername();
        try {
            return user != null && (this.userManager.isAdmin(user) || this.userManager.isSystemAdmin(user));
        }
        catch (NoSuchMethodError e) {
            return user != null && this.userManager.isSystemAdmin(user);
        }
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
    }

    private void handleUnpermittedUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.unpermitted"));
        context.put("displayLicenseAdminUi", false);
        this.renderer.render(TEMPLATE, context, (Writer)resp.getWriter());
    }
}

