/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification.transmission;

import java.util.List;
import java.util.Vector;
import javapns.devices.Device;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PayloadPerDevice;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushedNotifications;
import javapns.notification.transmission.NotificationProgressListener;
import javapns.notification.transmission.NotificationThread;
import javapns.notification.transmission.PushQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationThreads
extends ThreadGroup
implements PushQueue {
    private static final long DEFAULT_DELAY_BETWEEN_THREADS = 500L;
    private List<NotificationThread> threads = new Vector<NotificationThread>();
    private NotificationProgressListener listener;
    private boolean started = false;
    private int threadsRunning = 0;
    private int nextThread = 0;
    private Object finishPoint = new Object();
    private long delayBetweenThreads = 500L;

    public NotificationThreads(AppleNotificationServer server, Payload payload, List<Device> devices, int numberOfThreads) {
        super("javapns notification threads (" + numberOfThreads + " threads)");
        for (List deviceGroup : NotificationThreads.makeGroups(devices, numberOfThreads)) {
            this.threads.add(new NotificationThread(this, new PushNotificationManager(), server, payload, deviceGroup));
        }
    }

    public NotificationThreads(AppleNotificationServer server, List<PayloadPerDevice> messages, int numberOfThreads) {
        super("javapns notification threads (" + numberOfThreads + " threads)");
        for (List deviceGroup : NotificationThreads.makeGroups(messages, numberOfThreads)) {
            this.threads.add(new NotificationThread(this, new PushNotificationManager(), server, (Object)deviceGroup));
        }
    }

    public NotificationThreads(Object keystore, String password, boolean production, Payload payload, List<Device> devices, int numberOfThreads) throws Exception {
        this((AppleNotificationServer)new AppleNotificationServerBasicImpl(keystore, password, production), payload, devices, numberOfThreads);
    }

    public NotificationThreads(AppleNotificationServer server, Payload payload, List<Device> devices, List<NotificationThread> threads) {
        super("javapns notification threads (" + threads.size() + " threads)");
        this.threads = threads;
        List<List> groups = NotificationThreads.makeGroups(devices, threads.size());
        for (int i = 0; i < groups.size(); ++i) {
            threads.get(i).setDevices(groups.get(i));
        }
    }

    public NotificationThreads(Object keystore, String password, boolean production, Payload payload, List<Device> devices, List<NotificationThread> threads) throws Exception {
        this((AppleNotificationServer)new AppleNotificationServerBasicImpl(keystore, password, production), payload, devices, threads);
    }

    public NotificationThreads(AppleNotificationServer server, Payload payload, List<NotificationThread> threads) {
        super("javapns notification threads (" + threads.size() + " threads)");
        this.threads = threads;
    }

    public NotificationThreads(Object keystore, String password, boolean production, Payload payload, List<NotificationThread> threads) throws Exception {
        this((AppleNotificationServer)new AppleNotificationServerBasicImpl(keystore, password, production), payload, threads);
    }

    public NotificationThreads(AppleNotificationServer server, int numberOfThreads) {
        super("javapns notification thread pool (" + numberOfThreads + " threads)");
        for (int i = 0; i < numberOfThreads; ++i) {
            this.threads.add(new NotificationThread(this, new PushNotificationManager(), server));
        }
    }

    @Override
    public PushQueue add(Payload payload, String token) throws InvalidDeviceTokenFormatException {
        return this.add(new PayloadPerDevice(payload, token));
    }

    @Override
    public PushQueue add(Payload payload, Device device) {
        return this.add(new PayloadPerDevice(payload, device));
    }

    @Override
    public PushQueue add(PayloadPerDevice message) {
        this.start();
        NotificationThread targetThread = this.getNextAvailableThread();
        targetThread.add(message);
        return targetThread;
    }

    protected NotificationThread getNextAvailableThread() {
        for (int i = 0; i < this.threads.size(); ++i) {
            NotificationThread thread = this.getNextThread();
            boolean busy = thread.isBusy();
            if (busy) continue;
            return thread;
        }
        return this.getNextThread();
    }

    protected synchronized NotificationThread getNextThread() {
        if (this.nextThread >= this.threads.size()) {
            this.nextThread = 0;
        }
        NotificationThread thread = this.threads.get(this.nextThread++);
        return thread;
    }

    private static List<List> makeGroups(List objects, int threads) {
        int firstObject;
        Vector<List> groups = new Vector<List>(threads);
        int total = objects.size();
        int devicesPerThread = total / threads;
        if (total % threads > 0) {
            ++devicesPerThread;
        }
        for (int i = 0; i < threads && (firstObject = i * devicesPerThread) < total; ++i) {
            int lastObject = firstObject + devicesPerThread - 1;
            if (lastObject >= total) {
                lastObject = total - 1;
            }
            List threadObjects = objects.subList(firstObject, ++lastObject);
            groups.add(threadObjects);
        }
        return groups;
    }

    @Override
    public synchronized NotificationThreads start() {
        if (this.started) {
            return this;
        }
        this.started = true;
        if (this.threadsRunning > 0) {
            throw new IllegalStateException("NotificationThreads already started (" + this.threadsRunning + " still running)");
        }
        this.assignThreadsNumbers();
        for (NotificationThread thread : this.threads) {
            ++this.threadsRunning;
            thread.start();
            try {
                Thread.sleep(this.delayBetweenThreads);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.listener != null) {
            this.listener.eventAllThreadsStarted(this);
        }
        return this;
    }

    public void setMaxNotificationsPerConnection(int notifications) {
        for (NotificationThread thread : this.threads) {
            thread.setMaxNotificationsPerConnection(notifications);
        }
    }

    public void setSleepBetweenNotifications(long milliseconds) {
        for (NotificationThread thread : this.threads) {
            thread.setSleepBetweenNotifications(milliseconds);
        }
    }

    public List<NotificationThread> getThreads() {
        return this.threads;
    }

    public NotificationProgressListener getListener() {
        return this.listener;
    }

    public void setListener(NotificationProgressListener listener) {
        this.listener = listener;
        for (NotificationThread thread : this.threads) {
            thread.setListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void threadFinished(NotificationThread notificationThread) {
        --this.threadsRunning;
        if (this.threadsRunning == 0) {
            if (this.listener != null) {
                this.listener.eventAllThreadsFinished(this);
            }
            try {
                Object object = this.finishPoint;
                synchronized (object) {
                    this.finishPoint.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllThreads() throws InterruptedException {
        try {
            Object object = this.finishPoint;
            synchronized (object) {
                this.finishPoint.wait();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void waitForAllThreads(boolean throwCriticalExceptions) throws Exception {
        List<Exception> exceptions;
        this.waitForAllThreads();
        if (throwCriticalExceptions && (exceptions = this.getCriticalExceptions()).size() > 0) {
            throw exceptions.get(0);
        }
    }

    private void assignThreadsNumbers() {
        int t = 1;
        for (NotificationThread thread : this.threads) {
            thread.setThreadNumber(t++);
        }
    }

    @Override
    public PushedNotifications getPushedNotifications() {
        int capacity = 0;
        for (NotificationThread thread : this.threads) {
            capacity += thread.getPushedNotifications().size();
        }
        PushedNotifications all = new PushedNotifications(capacity);
        all.setMaxRetained(capacity);
        for (NotificationThread thread : this.threads) {
            all.addAll(thread.getPushedNotifications());
        }
        return all;
    }

    @Override
    public void clearPushedNotifications() {
        for (NotificationThread thread : this.threads) {
            thread.clearPushedNotifications();
        }
    }

    public PushedNotifications getFailedNotifications() {
        return this.getPushedNotifications().getFailedNotifications();
    }

    public PushedNotifications getSuccessfulNotifications() {
        return this.getPushedNotifications().getSuccessfulNotifications();
    }

    @Override
    public List<Exception> getCriticalExceptions() {
        Vector<Exception> exceptions = new Vector<Exception>();
        for (NotificationThread thread : this.threads) {
            Exception exception = thread.getCriticalException();
            if (exception == null) continue;
            exceptions.add(exception);
        }
        return exceptions;
    }

    public void setDelayBetweenThreads(long delayBetweenThreads) {
        this.delayBetweenThreads = delayBetweenThreads;
    }

    public long getDelayBetweenThreads() {
        return this.delayBetweenThreads;
    }
}

