/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushedNotification;
import javapns.notification.ResponsePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponsePacketReader {
    private static final int TIMEOUT = 5000;

    ResponsePacketReader() {
    }

    public static int processResponses(PushNotificationManager notificationManager) {
        List<ResponsePacket> responses = ResponsePacketReader.readResponses(notificationManager.getActiveSocket());
        ResponsePacketReader.handleResponses(responses, notificationManager);
        return responses.size();
    }

    private static List<ResponsePacket> readResponses(Socket socket) {
        Vector<ResponsePacket> responses = new Vector<ResponsePacket>();
        int previousTimeout = 0;
        try {
            ResponsePacket packet;
            try {
                previousTimeout = socket.getSoTimeout();
                socket.setSoTimeout(5000);
            }
            catch (Exception e) {
                // empty catch block
            }
            InputStream input = socket.getInputStream();
            while ((packet = ResponsePacketReader.readResponsePacketData(input)) != null) {
                responses.add(packet);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.setSoTimeout(previousTimeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return responses;
    }

    private static void handleResponses(List<ResponsePacket> responses, PushNotificationManager notificationManager) {
        Map<Integer, PushedNotification> envelopes = notificationManager.getPushedNotifications();
        for (ResponsePacket response : responses) {
            response.linkToPushedNotification(notificationManager);
        }
    }

    private static ResponsePacket readResponsePacketData(InputStream input) throws IOException {
        int command = input.read();
        if (command < 0) {
            return null;
        }
        int status = input.read();
        if (status < 0) {
            return null;
        }
        int identifier_byte1 = input.read();
        if (identifier_byte1 < 0) {
            return null;
        }
        int identifier_byte2 = input.read();
        if (identifier_byte2 < 0) {
            return null;
        }
        int identifier_byte3 = input.read();
        if (identifier_byte3 < 0) {
            return null;
        }
        int identifier_byte4 = input.read();
        if (identifier_byte4 < 0) {
            return null;
        }
        int identifier = (identifier_byte1 << 24) + (identifier_byte2 << 16) + (identifier_byte3 << 8) + identifier_byte4;
        return new ResponsePacket(command, status, identifier);
    }
}

