/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm.server;

import com.google.android.gcm.server.InvalidRequestException;
import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sender {
    protected static final String UTF8 = "UTF-8";
    protected static final int BACKOFF_INITIAL_DELAY = 1000;
    protected static final int MAX_BACKOFF_DELAY = 1024000;
    protected final Random random = new Random();
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String key;

    public Sender(String key) {
        this.key = Sender.nonNull(key);
    }

    public Result send(Message message, String registrationId, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Attempt #" + attempt + " to send message " + message + " to regIds " + registrationId);
            }
            boolean bl = tryAgain = (result = this.sendNoRetry(message, registrationId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not send message after " + attempt + " attempts");
        }
        return result;
    }

    public Result sendNoRetry(Message message, String registrationId) throws IOException {
        Integer timeToLive;
        String collapseKey;
        StringBuilder body = Sender.newBody("registration_id", registrationId);
        Boolean delayWhileIdle = message.isDelayWhileIdle();
        if (delayWhileIdle != null) {
            Sender.addParameter(body, "delay_while_idle", delayWhileIdle != false ? "1" : "0");
        }
        if ((collapseKey = message.getCollapseKey()) != null) {
            Sender.addParameter(body, "collapse_key", collapseKey);
        }
        if ((timeToLive = message.getTimeToLive()) != null) {
            Sender.addParameter(body, "time_to_live", Integer.toString(timeToLive));
        }
        for (Map.Entry<String, String> entry : message.getData().entrySet()) {
            String key = "data." + entry.getKey();
            String value = entry.getValue();
            Sender.addParameter(body, key, URLEncoder.encode(value, UTF8));
        }
        String requestBody = body.toString();
        this.logger.finest("Request body: " + requestBody);
        HttpURLConnection conn = this.post("https://android.googleapis.com/gcm/send", requestBody);
        int status = conn.getResponseCode();
        if (status == 503) {
            this.logger.fine("GCM service is unavailable");
            return null;
        }
        if (status != 200) {
            throw new InvalidRequestException(status);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            try {
                String line = reader.readLine();
                if (line == null || line.equals("")) {
                    throw new IOException("Received empty response from GCM service.");
                }
                String[] responseParts = this.split(line);
                String token = responseParts[0];
                String value = responseParts[1];
                if (token.equals("id")) {
                    Result.Builder builder = new Result.Builder().messageId(value);
                    line = reader.readLine();
                    if (line != null) {
                        responseParts = this.split(line);
                        token = responseParts[0];
                        value = responseParts[1];
                        if (token.equals("registration_id")) {
                            builder.canonicalRegistrationId(value);
                        } else {
                            this.logger.warning("Received invalid second line from GCM: " + line);
                        }
                    }
                    Result result = builder.build();
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Message created succesfully (" + result + ")");
                    }
                    Result result2 = result;
                    return result2;
                }
                if (token.equals("Error")) {
                    Result result = new Result.Builder().errorCode(value).build();
                    return result;
                }
                throw new IOException("Received invalid response from GCM: " + line);
            }
            finally {
                reader.close();
            }
        }
        finally {
            conn.disconnect();
        }
    }

    public MulticastResult send(Message message, List<String> regIds, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        MulticastResult multicastResult = null;
        int backoff = 1000;
        HashMap<String, Result> results = new HashMap<String, Result>();
        List<String> unsentRegIds = new ArrayList<String>(regIds);
        ArrayList<Long> multicastIds = new ArrayList<Long>();
        do {
            ++attempt;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Attempt #" + attempt + " to send message " + message + " to regIds " + unsentRegIds);
            }
            multicastResult = this.sendNoRetry(message, unsentRegIds);
            long multicastId = multicastResult.getMulticastId();
            this.logger.fine("multicast_id on attempt # " + attempt + ": " + multicastId);
            multicastIds.add(multicastId);
            unsentRegIds = this.updateStatus(unsentRegIds, results, multicastResult);
            boolean bl = tryAgain = !unsentRegIds.isEmpty() && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        int success = 0;
        int failure = 0;
        int canonicalIds = 0;
        for (Result result : results.values()) {
            if (result.getMessageId() != null) {
                ++success;
                if (result.getCanonicalRegistrationId() == null) continue;
                ++canonicalIds;
                continue;
            }
            ++failure;
        }
        long multicastId = (Long)multicastIds.remove(0);
        MulticastResult.Builder builder = new MulticastResult.Builder(success, failure, canonicalIds, multicastId).retryMulticastIds(multicastIds);
        for (String regId : regIds) {
            Result result = (Result)results.get(regId);
            builder.addResult(result);
        }
        return builder.build();
    }

    private List<String> updateStatus(List<String> unsentRegIds, Map<String, Result> allResults, MulticastResult multicastResult) {
        List<Result> results = multicastResult.getResults();
        if (results.size() != unsentRegIds.size()) {
            throw new RuntimeException("Internal error: sizes do not match. currentResults: " + results + "; unsentRegIds: " + unsentRegIds);
        }
        ArrayList<String> newUnsentRegIds = new ArrayList<String>();
        for (int i = 0; i < unsentRegIds.size(); ++i) {
            String regId = unsentRegIds.get(i);
            Result result = results.get(i);
            allResults.put(regId, result);
            String error = result.getErrorCodeName();
            if (error == null || !error.equals("Unavailable")) continue;
            newUnsentRegIds.add(regId);
        }
        return newUnsentRegIds;
    }

    public MulticastResult sendNoRetry(Message message, List<String> registrationIds) throws IOException {
        if (Sender.nonNull(registrationIds).isEmpty()) {
            throw new IllegalArgumentException("registrationIds cannot be empty");
        }
        HashMap<Object, Object> jsonRequest = new HashMap<Object, Object>();
        this.setJsonField(jsonRequest, "time_to_live", message.getTimeToLive());
        this.setJsonField(jsonRequest, "collapse_key", message.getCollapseKey());
        this.setJsonField(jsonRequest, "delay_while_idle", message.isDelayWhileIdle());
        jsonRequest.put("registration_ids", registrationIds);
        Map<String, String> payload = message.getData();
        if (!payload.isEmpty()) {
            jsonRequest.put("data", payload);
        }
        String requestBody = JSONValue.toJSONString(jsonRequest);
        this.logger.finest("JSON request: " + requestBody);
        HttpURLConnection conn = this.post("https://android.googleapis.com/gcm/send", "application/json", requestBody);
        int status = conn.getResponseCode();
        if (status != 200) {
            String responseBody = Sender.getString(conn.getErrorStream());
            this.logger.finest("JSON error response: " + responseBody);
            throw new InvalidRequestException(status, responseBody);
        }
        String responseBody = Sender.getString(conn.getInputStream());
        this.logger.finest("JSON response: " + responseBody);
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonResponse = (JSONObject)parser.parse(responseBody);
            int success = this.getNumber(jsonResponse, "success").intValue();
            int failure = this.getNumber(jsonResponse, "failure").intValue();
            int canonicalIds = this.getNumber(jsonResponse, "canonical_ids").intValue();
            long multicastId = this.getNumber(jsonResponse, "multicast_id").longValue();
            MulticastResult.Builder builder = new MulticastResult.Builder(success, failure, canonicalIds, multicastId);
            List results = (List)jsonResponse.get("results");
            if (results != null) {
                for (Map jsonResult : results) {
                    String messageId = (String)jsonResult.get("message_id");
                    String canonicalRegId = (String)jsonResult.get("registration_id");
                    String error = (String)jsonResult.get("error");
                    Result result = new Result.Builder().messageId(messageId).canonicalRegistrationId(canonicalRegId).errorCode(error).build();
                    builder.addResult(result);
                }
            }
            MulticastResult multicastResult = builder.build();
            return multicastResult;
        }
        catch (ParseException e) {
            throw this.newIoException(responseBody, e);
        }
        catch (CustomParserException e) {
            throw this.newIoException(responseBody, e);
        }
    }

    private IOException newIoException(String responseBody, Exception e) {
        String msg = "Error parsing JSON response (" + responseBody + ")";
        this.logger.log(Level.WARNING, msg, e);
        return new IOException(msg + ":" + e);
    }

    private void setJsonField(Map<Object, Object> json, String field, Object value) {
        if (value != null) {
            json.put(field, value);
        }
    }

    private Number getNumber(Map<?, ?> json, String field) {
        Object value = json.get(field);
        if (value == null) {
            throw new CustomParserException("Missing field: " + field);
        }
        if (!(value instanceof Number)) {
            throw new CustomParserException("Field " + field + " does not contain a number: " + value);
        }
        return (Number)value;
    }

    private String[] split(String line) throws IOException {
        String[] split = line.split("=", 2);
        if (split.length != 2) {
            throw new IOException("Received invalid response line from GCM: " + line);
        }
        return split;
    }

    protected HttpURLConnection post(String url, String body) throws IOException {
        return this.post(url, "application/x-www-form-urlencoded;charset=UTF-8", body);
    }

    protected HttpURLConnection post(String url, String contentType, String body) throws IOException {
        if (url == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!url.startsWith("https://")) {
            this.logger.warning("URL does not use https: " + url);
        }
        this.logger.fine("Sending POST to " + url);
        this.logger.finest("POST body: " + body);
        byte[] bytes = body.getBytes();
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.key);
        OutputStream out = conn.getOutputStream();
        out.write(bytes);
        out.close();
        return conn;
    }

    protected static final Map<String, String> newKeyValues(String key, String value) {
        HashMap<String, String> keyValues = new HashMap<String, String>(1);
        keyValues.put(Sender.nonNull(key), Sender.nonNull(value));
        return keyValues;
    }

    protected static StringBuilder newBody(String name, String value) {
        return new StringBuilder(Sender.nonNull(name)).append('=').append(Sender.nonNull(value));
    }

    protected static void addParameter(StringBuilder body, String name, String value) {
        Sender.nonNull(body).append('&').append(Sender.nonNull(name)).append('=').append(Sender.nonNull(value));
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Sender.nonNull(stream)));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    class CustomParserException
    extends RuntimeException {
        CustomParserException(String message) {
            super(message);
        }
    }
}

