var wrapFunction = function(fn, context, params) {
	return function() {
		fn.apply(context, params);
	};
};

var getDateRangeStartDate = function(dateRange, inputDate, days) {
	var m = moment();
	m.hour(0);
	m.minute(0);
	m.second(0);
	m.millisecond(0);
	switch (dateRange) {
	case "last_week":
		m.subtract(1, 'weeks').startOf('isoweek');
		break;
	case "last_month":
		m.subtract(1, 'months').startOf('month');
		break;
	case "current_week":
		m.startOf('isoweek');
		break;
	case "current_last_week":
		m.subtract(1, 'weeks').startOf('isoweek');
		break;
	case "current_month":
		m.startOf('month');
		break;
	case "last_n_days":
		m.subtract(days, 'days');
		break;
	case "today":
		m.subtract(0, 'days');
		break;
	case "yesterday":
		m.subtract(1, 'days');
		break;
	case "ytd":
		m.startOf('year');
		break;
	case "ytlm":
		m.startOf('year');
		break;
	case "ytcm":
		m.startOf('year');
		break;
	}
	if (dateRange === 'custom') {
		startDate = inputDate;
	} else {
		startDate = new Date(m.valueOf() + m.utcOffset() * 60000);
	}
	return startDate;
};

var getDateRangeEndDate = function(dateRange, inputDate) {
	var endDate = '';
	var m = moment();
	m.hour(0);
	m.minute(0);
	m.second(0);
	m.millisecond(0);

	switch (dateRange) {
	case "last_week":
		m.subtract(1, 'weeks').endOf('isoweek');
		break;
	case "last_month":
		m.subtract(1, 'months').endOf('month');
		break;
	case "current_week":
		m.endOf('isoweek');
		break;
	case "current_last_week":
		m.endOf('isoweek');
		break;
	case "current_month":
		m.endOf('month');
		break;
	case "last_n_days":
		m.subtract(1, 'days');
		break;
	case "today":
		m.subtract(0, 'days');
		break;
	case "yesterday":
		m.subtract(1, 'days');
		break;
	case "ytlm":
		m.subtract(1, 'months').endOf('month');
		break;
	case "ytcm":
		m.endOf('month');
		break;
	}
	if (dateRange === 'custom') {
		endDate = inputDate;
	} else {
		endDate = new Date(m.valueOf() + m.utcOffset() * 60000);
	}

	return endDate;
};

var getFormattedDate = function(date) {
	if (this.validDate(date)) {
		return moment(date).utc().format("YYYY-MM-DD");
	}
	return '';
};

var validDate = function(d) {
	if (Object.prototype.toString.call(d) === "[object Date]") {
		if (!isNaN(d.getTime())) {
			return true;
		}
	}
	return false;
};

var addDays = function(date, days) {
	if (validDate(date)) {
		var tmp = new Date();
		tmp.setTime(date.getTime() + (days * 86400000));
		return tmp;
	}
	return '';
};
var getDateFromFormattedString = function(str) {
	var year = str.substring(0, str.indexOf('-'));
	var month = str.substring(str.indexOf('-') + 1, str.lastIndexOf('-'));
	var day = str.substring(str.lastIndexOf('-') + 1);
	var d = new Date();
	d.setYear(year);
	d.setMonth(month - 1);
	d.setDate(day);
	d.setHours(0);
	d.setMinutes(0);
	d.setSeconds(0);
	return d;
};

var clientUrl = function(url, _public) {
	return GLOBAL.ctx + (GLOBAL.cloud ? '' : '/plugins/servlet')
			+ GLOBAL.addOnUrlPrefix + '/ajax' + (_public ? '-public/' : '/')
			+ url + '?_=' + (new Date()).getTime() + '&' + GLOBAL.queryString;
};
var findField = function(fieldId) {
	var field = null;
	$.each(GLOBAL.schema, function() {
		if (this.id === fieldId) {
			field = this;
			return false;
		}
	});
	return field;
};

var clone = function(obj) {
	return JSON.parse(JSON.stringify(obj));
};

var replaceAll = function(str, search, replacement) {
	return str.split(search).join(replacement);
};

var endsWith = function(str, pattern) {
	if (str && pattern) {
		var d = str.length - pattern.length;
		return d >= 0 && str.lastIndexOf(pattern) === d;
	}
	return false;
};

var removeValuesFromArray = function(arr, remove) {
	$.each(remove, function() {
		var itemtoRemove = this.toString();
		if ($.inArray(itemtoRemove, arr) > -1) {
			arr.splice($.inArray(itemtoRemove, arr), 1);
		}
	});
};
var getParameterByName = function(name, url) {
	if (!url) {
		url = window.location.href;
	}
	name = name.replace(/[\[\]]/g, "\\$&");
	var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"), results = regex
			.exec(url);
	if (!results)
		return null;
	if (!results[2])
		return '';
	return decodeURIComponent(results[2].replace(/\+/g, " "));
};

var replaceAll = function(str, search, replacement) {
	var target = str;
	return target.split(search).join(replacement);
};

var escapeScript = function(str) {
	if (str && (str.indexOf('</script>') > -1)) {
		str = replaceAll(str, '<script>', '&lt;script&gt;');
		str = replaceAll(str, '</script>', '&lt;&#47;script&gt;');
	}
	return str;
}
var numbersOnly = function(oToCheckField, oKeyEvent) {
	var s = String.fromCharCode(oKeyEvent.charCode);
	var containsDecimalPoint = /\./.test(oToCheckField.value);
	return oKeyEvent.charCode === 0 || /\d/.test(s) || /\./.test(s)
			&& !containsDecimalPoint;
}

var uniq = function(a) {
	return a.sort().filter(function(item, pos, ary) {
		return !pos || item != ary[pos - 1];
	})
}