var AioUserAutocomplete = function() {
	this.jc = new JiraClient();
};

AioUserAutocomplete.prototype.build = function(controlId, userOnly) {
	var obj = this;
	var fetch = function(query, callback) {
		if (query === '') {
			query = '%';
		}
		var url = '';
		if (GLOBAL.user_picker) {
			url = 'user/search?username=' + query;
		} else {
			url = 'user?username=' + query;
		}
		obj.jc.get(url, function(results) {
			var r = [];
			if (GLOBAL.user_picker) {
				$.each(results, function() {
					var ju = obj.jiraUserToAioUser(this);
					if (ju) {
						r.push(ju);
					}
				});
			} else {
				var ju = obj.jiraUserToAioUser(results);
				if (ju) {
					r.push(ju);
				}
			}
			if (!userOnly) {
				$.each(GLOBAL.teams, function(key, val) {
					if (query === '%' || ('Team: ' + val.name).toLowerCase().indexOf(query.toLowerCase()) > -1) {
						r.push(obj.aioTeam(key, val));
					}
				});
			}
			callback(r, query);
		}, true);
	};
	var ele = $("#" + controlId);
	ele.selectize({
		valueField : 'value',
		labelField : 'label',
		searchField : [ 'label' ],
		options : [],
		create : false,
		highlight : false,
		hideSelected : true,
		preload : 'focus',
		placeholder : ele.attr('placeholder') ? ele.attr('placeholder') : 'Start typing...',
		maxItems : null,
		load : function(query, callback) {
			fetch(query, callback);
		},
		onItemAdd : function(value, $item) {
			$item[0].innerHTML = $item[0].innerHTML.replace(' (' + JSON.parse(value).val + ')', '');
		}
	});
};

AioUserAutocomplete.prototype.addUser = function(controlId, jiraUser) {
	var user = this.jiraUserToAioUser(jiraUser);
	$('#' + controlId)[0].selectize.addOption(user);
	$('#' + controlId)[0].selectize.addItem(user.value);
};
AioUserAutocomplete.prototype.addTeam = function(controlId, teamId) {
	var team = this.aioTeam(teamId, GLOBAL.teams[teamId]);
	if (team) {
		$('#' + controlId)[0].selectize.addOption(team);
		$('#' + controlId)[0].selectize.addItem(team.value);
	}
};
AioUserAutocomplete.prototype.jiraUserToAioUser = function(jiraUser) {
	if (jiraUser.key) {
		var user = {
			label : jiraUser.displayName + ' (' + jiraUser.key + ')',
			value : JSON.stringify({
				val : jiraUser.key,
				'type' : 'user'
			}),
			name : jiraUser.displayName,
			tz : jiraUser.timeZone,
			emailAddress : jiraUser.emailAddress,
			username : jiraUser.name,
			userkey : jiraUser.key,
			type : 'user'
		};
		GLOBAL.userMap[jiraUser.key] = user;
		return user;
	}
	return null;
};

AioUserAutocomplete.prototype.aioTeam = function(teamId, team) {
	if (team) {
		return {
			label : 'Team: ' + team.name,
			value : JSON.stringify({
				val : teamId,
				'type' : 'team'
			})
		};
	}
	return null;
};