var TrendHelper = function() {
	this.jc = new JiraClient();
	this.ac = new AioClient();
};

TrendHelper.prototype.init = function() {
	if ($('#trend-datepicker').length > 0) {
		$('#trend-datepicker').datepicker({
			multidate : false,
			autoclose : true,
			todayHighlight : true,
			clearBtn : true,
			format : "M-dd-yyyy"
		});
		this.initDates();
		this.initValuesSelect();
	}
};

TrendHelper.prototype.run = function(dto, cb_processIssues) {
	var obj = this;
	dto.issues = [];
	var grandTotal = 0;
	obj.jc.post('search', {
		jql : dto.jql,
		maxResults : 0,
		expand : []
	}, function(results) {
		grandTotal = results.total;
		obj.ac.post('trendJqls', dto, function(results) {
			GLOBAL.totalIssues = results.length;
			var queue = [];
			var processJql = function(jql) {
				var _jql = jql[0];
				var _issue = jql[1];
				_jql = ((dto.jql === '') ? (_jql) : ('(' + dto.jql + ') and ('
						+ _jql + ')'));
				displayJql(_jql);
				obj.jc.post('search', {
					jql : _jql,
					maxResults : 0,
					expand : []
				}, function(results) {
					if (GLOBAL.cancelRun) {
						// do nothing
					} else {
						if (queue.length > 0) {
							(queue.shift())();
						}
						_issue.aio_total = results.total;
						_issue.aio_total_percent = (results.total*100)/grandTotal;
						var issue = {
							fields : _issue
						};
						dto.issues.push(issue);
						GLOBAL.fetchedIssues++;
						AioProgressBar.update(true);
						if (GLOBAL.fetchedIssues === GLOBAL.totalIssues) {
							cb_processIssues(dto);
						}
					}
				});
			};
			$.each(results, function() {
				var jql = this;
				queue.push(wrapFunction(processJql, obj, [ jql ]));
			});
			for (var i = 0; i < GLOBAL.parallel; i++) {
				if (queue.length > 0) {
					(queue.shift())();
				}
			}
		});
	});
};

TrendHelper.prototype.initValuesSelect = function(cb) {
	var select = $('#trend-values-select');

	var buildMultiSelect = function() {
		select.multiselect({
			buttonContainer : '<div class="btn-group btn-group-sm" />',
			onChange : function(option, checked) {
				if (checked) {
					if (option.val() === '') {
						select.multiselect('deselectAll');
						select.multiselect('select', option.val());
					} else {
						select.multiselect('deselect', '');
					}
				} else {
					if (option.val() === '') {
						select.multiselect('select', option.val());
					} else {
						if (select.val().length === 0) {
							select.multiselect('select', '');
						}
					}
				}
			}
		});
		select.multiselect('rebuild');
		select.multiselect('select', '');
		if (cb) {
			cb();
		}
	};

	var obj = this;
	var field = this.getField();
	select.find('option').remove();
	var option = $('<option>').text('All').val('');
	select.append(option);
	if (field === 'created_resolved') {
		option = $('<option>').text('Created Date').val('Created');
		select.append(option);
		option = $('<option>').text('Resolved Date').val('Resolved');
		select.append(option);
		buildMultiSelect();
	} else {
		obj.jc.get(field, function(results) {
			$.each(results, function() {
				option = $('<option>').text(this.name).val(this.name);
				select.append(option);
			});
			buildMultiSelect();
		});
	}

};
TrendHelper.prototype.getField = function() {
	return $('#trend-field-select').val();
};
TrendHelper.prototype.getDateRange = function() {
	return $('#trend-date-range-select').val();
};

TrendHelper.prototype.getStartDate = function() {
	return $('#trend-datepicker [name="start"]').datepicker('getUTCDate');
};

TrendHelper.prototype.getEndDate = function() {
	return $('#trend-datepicker [name="end"]').datepicker('getUTCDate');
};

TrendHelper.prototype.getValues = function() {
	var values = [];
	$.each($('#trend-values-select').val(), function() {
		if (this.toString() !== '') {
			values.push(this.toString());
		}
	});
	if (values.length === 0) {
		$.each($('#trend-values-select').find('option'), function() {
			if ($(this).val() !== '') {
				values.push($(this).val());
			}
		});
	}
	return values;
};

TrendHelper.prototype.getInterval = function() {
	return $('#trend-interval-select').val();
};

TrendHelper.prototype.getOutputFormat = function() {
	return $('#trend-output-select').val();
};

TrendHelper.prototype.getBreakByIssueType = function() {
	return $('#trend-check-break-by-issuetype').is(":checked");
};

TrendHelper.prototype.getShowPercentages = function() {
	return $('#trend-check-show-percentages').is(":checked");
};

TrendHelper.prototype.getShowCumulative = function() {
	return $('#trend-check-show-cumulative').is(":checked");
};
TrendHelper.prototype.setField = function(val) {
	$('#trend-field-select').val(val);
};
TrendHelper.prototype.setValues = function(val) {
	if (val) {
		$('#trend-values-select').multiselect('deselect', '');
		$.each(val, function() {
			$('#trend-values-select').multiselect('select', this.toString());
		});
	}

};
TrendHelper.prototype.setDateRange = function(val) {
	$('#trend-date-range-select').val(val);
};

TrendHelper.prototype.setStartDate = function(val) {
	$('#trend-datepicker [name="start"]').datepicker('setUTCDate', val);
};

TrendHelper.prototype.setEndDate = function(val) {
	$('#trend-datepicker [name="end"]').datepicker('setUTCDate', val);
};

TrendHelper.prototype.setTrendInterval = function(val) {
	$('#trend-interval-select').val(val);
};

TrendHelper.prototype.setOutputFormat = function(val) {
	$('#trend-output-select').val(val);
};

TrendHelper.prototype.setBreakByIssueType = function(val) {
	$('#trend-check-break-by-issuetype').prop('checked', val);
};

TrendHelper.prototype.setShowPercentages = function(val) {
	$('#trend-check-show-percentages').prop('checked', val);
};

TrendHelper.prototype.setShowCumulative = function(val) {
	$('#trend-check-show-cumulative').prop('checked', val);
};

TrendHelper.prototype.setOutputFormat = function(val) {
	$('#trend-output-select').val(val);
};
TrendHelper.prototype.initOutputFormat = function() {
	var chk = $("#trend-check-break-by-issuetype");
	if (chk.prop('checked')) {
		$('#trend-output-select').val('table');
		$('#trend-output-select').prop('disabled', true);
	} else {
		$('#trend-output-select').prop('disabled', false);
	}

};
TrendHelper.prototype.initDates = function() {
	var dateRange = this.getDateRange();
	var startDate = getDateRangeStartDate(dateRange, $(
			'#trend-datepicker [name="start"]').datepicker('getUTCDate'));
	var endDate = getDateRangeEndDate(dateRange, $(
			'#trend-datepicker [name="end"]').datepicker('getUTCDate'));
	this.setStartDate(startDate);
	this.setEndDate(endDate);

	if (dateRange === 'custom') {
		$('#trend-datepicker [name="start"]').prop('disabled', false);
		$('#trend-datepicker [name="end"]').prop('disabled', false);
	} else {
		$('#trend-datepicker [name="start"]').prop('disabled', true);
		$('#trend-datepicker [name="end"]').prop('disabled', true);
	}
};

TrendHelper.prototype.getJql = function() {
};
