$(function() {
	if (GLOBAL.timeEntry) {
		GLOBAL.schema = GLOBAL.timeEntrySchema;
		GLOBAL.schemaLoaded = true;
	} else {
		var jc = new JiraClient();
		var ac = new AioClient();
		$('#dialog-block-ui').modal({
			backdrop : 'static',
			keyboard : false
		});
		jc.get('field', function(results) {
			var fields = results;
			cleanSchemaData(fields);
			jc.get('jql/autocompletedata', function(results) {
				var autocompletedata = results;
				delete autocompletedata['jqlReservedWords'];
				delete autocompletedata['visibleFunctionNames'];

				cleanSchemaData(autocompletedata['visibleFieldNames']);
				jc.get('priority', function(results) {
					ac.post('schema', {
						fields : fields,
						autocompletedata : autocompletedata,
						quickTimesheet : (GLOBAL.quickTimesheet ? true : false),
						priorities : results
					}, function(results) {
						GLOBAL.schema = results.schema;
						GLOBAL.dateFormats = results.dateFormats;
						GLOBAL.filters = results.filters;
						GLOBAL.operatorMapFE = results.operatorMapFE;
						GLOBAL.priorities = results.priorities;
						if ($('#aio-filter-custom').length > 0) {
							var filter = new Filter();
							filter.buildCustomInterface($('#aio-filter-custom'), GLOBAL.filters);
						}
						GLOBAL.schemaLoaded = true;
						if (($('#aio-fields-tree').length > 0) || GLOBAL.quickTimesheet || GLOBAL.timeInStatus) {
							GLOBAL.treeFields = GLOBAL.schema;
							var rs = new ReportService();
							rs.open();
							buildTree();
							$('#btn-dialog-matrix-dimension-row').click(function() {
								_addField(GLOBAL._matrixField, 'row');
								$('#dialog-matrix-dimension').modal('hide');
							});
							$('#btn-dialog-matrix-dimension-col').click(function() {
								_addField(GLOBAL._matrixField, 'col');
								$('#dialog-matrix-dimension').modal('hide');
							});
						}
					});
				});
			});
		});
	}
});
var _addField = function(field, sectionType) {
	var _addFieldLocal = function(reportType, section, field) {
		if (field.measure && (reportType !== 'list' && reportType !== 'timesheet')) {
			section = dataSection(reportType);
		}
		addField(section[0], field);
	};
	var reportType = getReportType();
	if (reportType === 'matrix' && !field.measure) {
		if (sectionType) {
			if (sectionType === 'row') {
				_addFieldLocal(reportType, rowSection(reportType), field);
			} else {
				_addFieldLocal(reportType, columnSection(reportType), field);
			}
		} else {
			GLOBAL._matrixField = field;
			$('#dialog-matrix-dimension').modal({
				backdrop : 'static',
				keyboard : false
			});
		}
	} else {
		var section = rowSection(reportType);
		if ((reportType === 'bar' || reportType === 'line') && !field.measure) {
			var currentLength = $(section).find('ul:first').children('li').length;
			if (currentLength > 0) {
				section = columnSection(reportType);
			}
		}
		_addFieldLocal(reportType, section, field);
	}
};
var buildTree = function() {

	var fields = GLOBAL.treeFields;
	var firstField = true;
	var firstIn = false;
	var popup = ($('#aio-measure').length === 0);

	$.each(fields, function() {
		if (this.reportable) {
			var div = $('<div class="btn-group draggable field"><div class="btn btn-default btn-sm movable">' + this.name
					+ '</div><div class="btn btn-default btn-sm"><i class="fa fa-plus-circle fa-lg" aria-hidden="true"></i></div></div>');
			div.attr('id', 'tree-btn-' + this.id);
			div.data({
				'field' : this
			});
			div.find('i').parent().on('click', function() {
				_addField($(this).parent().data()['field']);
			});
			var parent = $('#aio-dimension-accordion');
			if (firstField) {
				firstIn = true;
				firstField = false;
			}

			if (!this.group) {
				this.group = 'Other';
			}
			var groupName = this.group;
			this.group = this.group.split(' ').join('_');
			var panelId = parent.attr('id') + '-' + this.group;
			var childId = panelId + '-child';
			var child = $('#' + childId);
			if (child.length === 0) {
				var html = '<div class="panel panel-default"><div class="panel-heading accordion-toggle ' + (firstIn ? '' : 'collapsed') + '" id="' + panelId
						+ '"  data-toggle="collapse" data-parent="#' + parent.attr('id') + '" data-target="#' + childId + '"><span class="panel-title">' + this.group.split('_').join(' ')
						+ '</span></div>';
				html += '<div id="' + childId + '" class="panel-collapse collapse ' + (firstIn ? 'in' : '') + '" role="tabpanel" aria-labelledby="' + panelId + '"><div class="panel-body">';
				html += '</div>';
				parent.append(html);
				child = $('#' + childId);
				firstIn = false;
			}
			if (this.measure) {
				if (child.find('.panel-body').find('.meas').length === 0) {
					child.find('.panel-body').append('<div class="meas">Measures</div>');
				}
				child.find('.panel-body').find('.meas').after(div);
			} else {
				if (child.find('.panel-body').find('.dim').length === 0) {
					if (child.find('.panel-body').find('.meas').length > 0) {
						child.find('.panel-body').find('.meas').before('<div class="dim">Dimensions</div>');
					} else {
						child.find('.panel-body').append('<div class="dim">Dimensions</div>');
					}
				}
				child.find('.panel-body').find('.dim').after(div);
			}

		}
	});
	$(".draggable").draggable({
		revert : "invalid",
		helper : "clone"
	});
};

var searchFields = function(term) {
	GLOBAL.treeFields = [];
	$.each(GLOBAL.schema, function() {
		var field = this;
		if (field.name.toLowerCase().indexOf(term.toLowerCase()) > -1) {
			GLOBAL.treeFields.push(field);
		}
	});
	$('#aio-dimension-accordion').html('');
	$('#aio-measure-accordion').html('');
	buildTree();
	var allFields = getSectionFields('row').concat(getSectionFields('column')).concat(getSectionFields('data'));
	$.each(allFields, function() {
		highlightTreeField(this);
	});
};

var showFieldsPopup = function() {
	var fields = GLOBAL.treeFields;
	var first = true;
	$('#dialog-fields-popup').modal({
		backdrop : 'static',
		keyboard : false
	});
};

var cleanSchemaData = function(json) {
	$.each(json, function() {
		try {
			delete this['orderable'];
			delete this['navigable'];
			delete this['searchable'];
			delete this['displayName'];
			delete this['cfid'];
		} catch (err) {
		}
	});
};